/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for BlikOneClickPaymentObject type.
 */
public class BlikOneClickPaymentObject {
    private String consumerReference;

    /**
     * Default constructor.
     */
    public BlikOneClickPaymentObject() {
    }

    /**
     * Initialization constructor.
     * @param  consumerReference  String value for consumerReference.
     */
    public BlikOneClickPaymentObject(
            String consumerReference) {
        this.consumerReference = consumerReference;
    }

    /**
     * Getter for ConsumerReference.
     * The merchant generated, unique reference serving as a primary identifier for accounts
     * connected between Blik and a merchant.
     * @return Returns the String
     */
    @JsonGetter("consumer_reference")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getConsumerReference() {
        return consumerReference;
    }

    /**
     * Setter for ConsumerReference.
     * The merchant generated, unique reference serving as a primary identifier for accounts
     * connected between Blik and a merchant.
     * @param consumerReference Value for String
     */
    @JsonSetter("consumer_reference")
    public void setConsumerReference(String consumerReference) {
        this.consumerReference = consumerReference;
    }

    /**
     * Converts this BlikOneClickPaymentObject into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "BlikOneClickPaymentObject [" + "consumerReference=" + consumerReference + "]";
    }

    /**
     * Builds a new {@link BlikOneClickPaymentObject.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link BlikOneClickPaymentObject.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .consumerReference(getConsumerReference());
        return builder;
    }

    /**
     * Class to build instances of {@link BlikOneClickPaymentObject}.
     */
    public static class Builder {
        private String consumerReference;



        /**
         * Setter for consumerReference.
         * @param  consumerReference  String value for consumerReference.
         * @return Builder
         */
        public Builder consumerReference(String consumerReference) {
            this.consumerReference = consumerReference;
            return this;
        }

        /**
         * Builds a new {@link BlikOneClickPaymentObject} object using the set fields.
         * @return {@link BlikOneClickPaymentObject}
         */
        public BlikOneClickPaymentObject build() {
            return new BlikOneClickPaymentObject(consumerReference);
        }
    }
}
