/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;


/**
 * AvsCode to be used.
 */
public enum AvsCode {
    /**
     * For Visa, Mastercard, or Discover transactions, the address matches but the zip code does not match. For American Express transactions, the card holder address is correct.
     */
    AVS_A,

    /**
     * For Visa, Mastercard, or Discover transactions, the address matches. International A.
     */
    AVS_B,

    /**
     * For Visa, Mastercard, or Discover transactions, no values match. International N.
     */
    AVS_C,

    /**
     * For Visa, Mastercard, or Discover transactions, the address and postal code match. International X.
     */
    AVS_D,

    /**
     * For Visa, Mastercard, or Discover transactions, not allowed for Internet or phone transactions. For American Express card holder, the name is incorrect but the address and postal code match.
     */
    AVS_E,

    /**
     * For Visa, Mastercard, or Discover transactions, the address and postal code match. UK-specific X. For American Express card holder, the name is incorrect but the address matches.
     */
    AVS_F,

    /**
     * For Visa, Mastercard, or Discover transactions, global is unavailable. Nothing matches.
     */
    AVS_G,

    /**
     * For Visa, Mastercard, or Discover transactions, international is unavailable. Not applicable.
     */
    AVS_I,

    /**
     * For Visa, Mastercard, or Discover transactions, the address and postal code match. For American Express card holder, the name, address, and postal code match.
     */
    AVS_M,

    /**
     * For Visa, Mastercard, or Discover transactions, nothing matches. For American Express card holder, the address and postal code are both incorrect.
     */
    AVS_N,

    /**
     * For Visa, Mastercard, or Discover transactions, postal international Z. Postal code only.
     */
    AVS_P,

    /**
     * For Visa, Mastercard, or Discover transactions, re-try the request. For American Express, the system is unavailable.
     */
    AVS_R,

    /**
     * For Visa, Mastercard, Discover, or American Express, the service is not supported.
     */
    AVS_S,

    /**
     * For Visa, Mastercard, or Discover transactions, the service is unavailable. For American Express, information is not available. For Maestro, the address is not checked or the acquirer had no response. The service is not available.
     */
    AVS_U,

    /**
     * For Visa, Mastercard, or Discover transactions, whole ZIP code. For American Express, the card holder name, address, and postal code are all incorrect.
     */
    AVS_W,

    /**
     * For Visa, Mastercard, or Discover transactions, exact match of the address and the nine-digit ZIP code. For American Express, the card holder name, address, and postal code are all incorrect.
     */
    AVS_X,

    /**
     * For Visa, Mastercard, or Discover transactions, the address and five-digit ZIP code match. For American Express, the card holder address and postal code are both correct.
     */
    AVS_Y,

    /**
     * For Visa, Mastercard, or Discover transactions, the five-digit ZIP code matches but no address. For American Express, only the card holder postal code is correct.
     */
    AVS_Z,

    /**
     * For Maestro, no AVS response was obtained.
     */
    AVS_NULL,

    /**
     * For Maestro, all address information matches.
     */
    AVS_0,

    /**
     * For Maestro, none of the address information matches.
     */
    AVS_1,

    /**
     * For Maestro, part of the address information matches.
     */
    AVS_2,

    /**
     * For Maestro, the merchant did not provide AVS information. It was not processed.
     */
    AVS_3,

    /**
     * For Maestro, the address was not checked or the acquirer had no response. The service is not available.
     */
    AVS_4,

    /**
     * Unknown values will be mapped by this enum member
     */
    _UNKNOWN;


    private static TreeMap<String, AvsCode> valueMap = new TreeMap<>();
    private String value;

    static {
        AVS_A.value = "A";
        AVS_B.value = "B";
        AVS_C.value = "C";
        AVS_D.value = "D";
        AVS_E.value = "E";
        AVS_F.value = "F";
        AVS_G.value = "G";
        AVS_I.value = "I";
        AVS_M.value = "M";
        AVS_N.value = "N";
        AVS_P.value = "P";
        AVS_R.value = "R";
        AVS_S.value = "S";
        AVS_U.value = "U";
        AVS_W.value = "W";
        AVS_X.value = "X";
        AVS_Y.value = "Y";
        AVS_Z.value = "Z";
        AVS_NULL.value = "Null";
        AVS_0.value = "0";
        AVS_1.value = "1";
        AVS_2.value = "2";
        AVS_3.value = "3";
        AVS_4.value = "4";
        _UNKNOWN.value = null;

        valueMap.put("A", AVS_A);
        valueMap.put("B", AVS_B);
        valueMap.put("C", AVS_C);
        valueMap.put("D", AVS_D);
        valueMap.put("E", AVS_E);
        valueMap.put("F", AVS_F);
        valueMap.put("G", AVS_G);
        valueMap.put("I", AVS_I);
        valueMap.put("M", AVS_M);
        valueMap.put("N", AVS_N);
        valueMap.put("P", AVS_P);
        valueMap.put("R", AVS_R);
        valueMap.put("S", AVS_S);
        valueMap.put("U", AVS_U);
        valueMap.put("W", AVS_W);
        valueMap.put("X", AVS_X);
        valueMap.put("Y", AVS_Y);
        valueMap.put("Z", AVS_Z);
        valueMap.put("Null", AVS_NULL);
        valueMap.put("0", AVS_0);
        valueMap.put("1", AVS_1);
        valueMap.put("2", AVS_2);
        valueMap.put("3", AVS_3);
        valueMap.put("4", AVS_4);
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     * @throws IOException when provided value is not mapped to any enum member.
     */
    @JsonCreator
    public static AvsCode constructFromString(String toConvert) throws IOException {
        AvsCode enumValue = fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     */
    public static AvsCode fromString(String toConvert) {
        if (!valueMap.containsKey(toConvert)) {
            return _UNKNOWN;
        }
        return valueMap.get(toConvert);
    }

    /**
     * Returns the string value associated with the enum member.
     * @return The string value against enum member.
     */
    @JsonValue
    public String value() {
        return value;
    }
        
    /**
     * Get string representation of this enum.
     */
    @Override
    public String toString() {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    /**
     * Convert list of AvsCode values to list of string values.
     * @param toConvert The list of AvsCode values to convert.
     * @return List of representative string values.
     */
    public static List<String> toValue(List<AvsCode> toConvert) {
        if (toConvert == null) {
            return null;
        }
        List<String> convertedValues = new ArrayList<>();
        for (AvsCode enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }
} 