/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.ipn;

import com.paypal.core.ConfigManager;
import com.paypal.core.ConnectionManager;
import com.paypal.core.HttpConfiguration;
import com.paypal.core.HttpConnection;
import com.paypal.core.LoggingManager;
import com.paypal.core.SDKUtil;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPNMessage {
    private static final long serialVersionUID = -7187275404183441828L;
    private static final String ENCODING = "windows-1252";
    private Map<String, String> ipnMap = new HashMap<String, String>();
    private Map<String, String> configurationMap = null;
    private HttpConfiguration httpConfiguration = null;
    private String ipnEndpoint = "";
    private boolean isIpnVerified = false;
    private StringBuffer payload;

    private void initialize() {
        this.httpConfiguration = new HttpConfiguration();
        this.ipnEndpoint = this.getIPNEndpoint();
        this.httpConfiguration.setEndPointUrl(this.ipnEndpoint);
        this.httpConfiguration.setConnectionTimeout(Integer.parseInt(this.configurationMap.get("http.ConnectionTimeOut")));
        this.httpConfiguration.setMaxRetry(Integer.parseInt(this.configurationMap.get("http.Retry")));
        this.httpConfiguration.setReadTimeout(Integer.parseInt(this.configurationMap.get("http.ReadTimeOut")));
        this.httpConfiguration.setMaxHttpConnection(Integer.parseInt(this.configurationMap.get("http.MaxConnection")));
    }

    public IPNMessage(HttpServletRequest request) {
        this(request.getParameterMap());
    }

    public IPNMessage(Map<String, String[]> ipnMap) {
        this(ipnMap, ConfigManager.getInstance().getConfigurationMap());
    }

    public IPNMessage(HttpServletRequest request, Map<String, String> configurationMap) {
        this(request.getParameterMap(), configurationMap);
    }

    public IPNMessage(Map<String, String[]> ipnMap, Map<String, String> configurationMap) {
        this.configurationMap = SDKUtil.combineDefaultMap(configurationMap);
        this.initialize();
        this.payload = new StringBuffer("cmd=_notify-validate");
        if (ipnMap != null) {
            String[] encodingParam = ipnMap.get("charset");
            String encoding = encodingParam != null && encodingParam.length > 0 ? encodingParam[0] : ENCODING;
            for (Map.Entry<String, String[]> entry : ipnMap.entrySet()) {
                String name = entry.getKey();
                String[] value = entry.getValue();
                try {
                    this.ipnMap.put(name, URLDecoder.decode(value[0], encoding));
                    this.payload.append("&").append(name).append("=").append(URLEncoder.encode(value[0], encoding));
                }
                catch (Exception e) {
                    LoggingManager.debug(IPNMessage.class, e.getMessage());
                }
            }
        }
    }

    public boolean validate() {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        URL url = null;
        String res = "";
        HttpConnection connection = ConnectionManager.getInstance().getConnection();
        try {
            connection.createAndconfigureHttpConnection(this.httpConfiguration);
            url = new URL(this.ipnEndpoint);
            headerMap.put("Host", url.getHost());
            res = "";
            if (!this.isIpnVerified) {
                res = connection.execute(null, this.payload.toString(), headerMap);
            }
        }
        catch (Exception e) {
            LoggingManager.debug(IPNMessage.class, e.getMessage());
        }
        if (res.equals("VERIFIED")) {
            this.isIpnVerified = true;
        }
        return this.isIpnVerified;
    }

    public Map<String, String> getIpnMap() {
        return this.ipnMap;
    }

    public String getIpnValue(String ipnName) {
        return this.ipnMap.get(ipnName);
    }

    public String getTransactionType() {
        return this.ipnMap.containsKey("txn_type") ? this.ipnMap.get("txn_type") : this.ipnMap.get("transaction_type");
    }

    private String getIPNEndpoint() {
        String ipnEPoint = null;
        ipnEPoint = this.configurationMap.get("service.IPNEndpoint");
        if (ipnEPoint == null) {
            String mode = this.configurationMap.get("mode");
            if (mode != null && "sandbox".equalsIgnoreCase(this.configurationMap.get("mode").trim())) {
                ipnEPoint = "https://www.sandbox.paypal.com/cgi-bin/webscr";
            } else if (mode != null && "live".equalsIgnoreCase(this.configurationMap.get("mode").trim())) {
                ipnEPoint = "https://www.paypal.com/cgi-bin/webscr";
            }
        }
        return ipnEPoint;
    }
}

