/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.core;

import com.paypal.core.ConfigManager;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SDKUtil {
    private static final Pattern AMPERSAND_REPLACE = Pattern.compile("&((?!amp;)(?!lt;)(?!gt;)(?!apos;)(?!quot;))");
    private static final Pattern LESSERTHAN_REPLACE = Pattern.compile("<");
    private static final Pattern GREATERTHAN_REPLACE = Pattern.compile(">");
    private static final Pattern QUOT_REPLACE = Pattern.compile("\"");
    private static final Pattern APOSTROPHE_REPLACE = Pattern.compile("'");
    private static final String AMPERSAND = "&amp;";
    private static final String GREATERTHAN = "&gt;";
    private static final String LESSERTHAN = "&lt;";
    private static final String QUOT = "&quot;";
    private static final String APOSTROPHE = "&apos;";

    private SDKUtil() {
    }

    public static String escapeInvalidXmlChars(String textContent) {
        StringBuilder stringBuilder = null;
        String response = null;
        if (textContent != null) {
            stringBuilder = new StringBuilder();
            int contentLength = textContent.toCharArray().length;
            for (int i = 0; i < contentLength; ++i) {
                char ch = textContent.charAt(i);
                if (ch == '&') {
                    if (i != contentLength - 1) {
                        if (i + 3 <= contentLength - 1 && (textContent.charAt(i + 1) == 'g' || textContent.charAt(i + 1) == 'l') && textContent.charAt(i + 2) == 't' && textContent.charAt(i + 3) == ';') {
                            stringBuilder.append(ch);
                            continue;
                        }
                        if (i + 4 <= contentLength - 1 && textContent.charAt(i + 1) == 'a' && textContent.charAt(i + 2) == 'm' && textContent.charAt(i + 3) == 'p' && textContent.charAt(i + 4) == ';') {
                            stringBuilder.append(ch);
                            continue;
                        }
                        if (i + 5 <= contentLength - 1 && (textContent.charAt(i + 1) == 'q' && textContent.charAt(i + 2) == 'u' && textContent.charAt(i + 3) == 'o' && textContent.charAt(i + 4) == 't' || textContent.charAt(i + 1) == 'a' && textContent.charAt(i + 2) == 'p' && textContent.charAt(i + 3) == 'o' && textContent.charAt(i + 4) == 's' && textContent.charAt(i + 5) == ';')) {
                            stringBuilder.append(ch);
                            continue;
                        }
                        stringBuilder.append(AMPERSAND);
                        continue;
                    }
                    stringBuilder.append(AMPERSAND);
                    continue;
                }
                if (ch == '<') {
                    stringBuilder.append(LESSERTHAN);
                    continue;
                }
                if (ch == '>') {
                    stringBuilder.append(GREATERTHAN);
                    continue;
                }
                if (ch == '\"') {
                    stringBuilder.append(QUOT);
                    continue;
                }
                if (ch == '\'') {
                    stringBuilder.append(APOSTROPHE);
                    continue;
                }
                stringBuilder.append(ch);
            }
            response = stringBuilder.toString();
        }
        return response;
    }

    public static String escapeInvalidXmlCharsRegex(String textContent) {
        String response = "";
        if (textContent != null && textContent.length() != 0) {
            response = APOSTROPHE_REPLACE.matcher(QUOT_REPLACE.matcher(GREATERTHAN_REPLACE.matcher(LESSERTHAN_REPLACE.matcher(AMPERSAND_REPLACE.matcher(textContent).replaceAll(AMPERSAND)).replaceAll(LESSERTHAN)).replaceAll(GREATERTHAN)).replaceAll(QUOT)).replaceAll(APOSTROPHE);
        }
        return response;
    }

    public static String escapeInvalidXmlCharsRegex(Integer intContent) {
        String response = null;
        String textContent = null;
        if (intContent != null) {
            textContent = intContent.toString();
            response = SDKUtil.escapeInvalidXmlCharsRegex(textContent);
        }
        return response;
    }

    public static String escapeInvalidXmlCharsRegex(Long longContent) {
        String response = null;
        String textContent = null;
        if (longContent != null) {
            textContent = longContent.toString();
            response = SDKUtil.escapeInvalidXmlCharsRegex(textContent);
        }
        return response;
    }

    public static String escapeInvalidXmlCharsRegex(Boolean boolContent) {
        String response = null;
        String textContent = null;
        if (boolContent != null) {
            textContent = boolContent.toString();
            response = SDKUtil.escapeInvalidXmlCharsRegex(textContent);
        }
        return response;
    }

    public static String escapeInvalidXmlCharsRegex(Double doubleContent) {
        String response = null;
        String textContent = null;
        if (doubleContent != null) {
            textContent = doubleContent.toString();
            response = SDKUtil.escapeInvalidXmlCharsRegex(textContent);
        }
        return response;
    }

    public static String escapeInvalidXmlCharsRegex(Float floatContent) {
        String response = null;
        String textContent = null;
        if (floatContent != null) {
            textContent = floatContent.toString();
            response = SDKUtil.escapeInvalidXmlCharsRegex(textContent);
        }
        return response;
    }

    public static Map<String, String> constructMap(Properties properties) {
        HashMap<String, String> propsMap = null;
        Properties combinedProperties = ConfigManager.combineDefaultProperties(properties);
        propsMap = new HashMap<String, String>();
        Enumeration<?> keys = combinedProperties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString().trim();
            String value = combinedProperties.getProperty(key).trim();
            propsMap.put(key, value);
        }
        return propsMap;
    }

    public static Map<String, String> combineDefaultMap(Map<String, String> receivedMap) {
        Map<String, String> combinedMap = ConfigManager.getDefaultSDKMap();
        combinedMap.putAll(receivedMap);
        return combinedMap;
    }
}

