/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.core;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LoggingManager {
    private static Map<Class<?>, Logger> loggerMap = new HashMap();

    private LoggingManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Logger getLogger(Class<?> thisClass) {
        if (loggerMap.get(thisClass) == null) {
            Map<Class<?>, Logger> map = loggerMap;
            synchronized (map) {
                if (loggerMap.get(thisClass) == null) {
                    loggerMap.put(thisClass, Logger.getLogger(thisClass.getCanonicalName()));
                }
            }
        }
        return loggerMap.get(thisClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(Level priority, Class<?> thisClass, Object message) {
        Logger logger;
        Logger logger2 = logger = LoggingManager.getLogger(thisClass);
        synchronized (logger2) {
            if (logger.isLoggable(priority)) {
                logger.log(priority, (String)message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(Level priority, Class<?> thisClass, Object message, Throwable t) {
        Logger logger;
        Logger logger2 = logger = LoggingManager.getLogger(thisClass);
        synchronized (logger2) {
            if (logger.isLoggable(priority)) {
                logger.log(priority, (String)message, t);
            }
        }
    }

    public static void debug(Class<?> thisClass, Object message) {
        LoggingManager.log(Level.FINEST, thisClass, message);
    }

    public static void debug(Class<?> thisClass, Object message, Throwable t) {
        LoggingManager.log(Level.FINEST, thisClass, message, t);
    }

    public static void info(Class<?> thisClass, Object message) {
        LoggingManager.log(Level.INFO, thisClass, message);
    }

    public static void info(Class<?> thisClass, Object message, Throwable t) {
        LoggingManager.log(Level.INFO, thisClass, message, t);
    }

    public static void warn(Class<?> thisClass, Object message) {
        LoggingManager.log(Level.WARNING, thisClass, message);
    }

    public static void warn(Class<?> thisClass, Object message, Throwable t) {
        LoggingManager.log(Level.WARNING, thisClass, message, t);
    }

    public static void severe(Class<?> thisClass, Object message) {
        LoggingManager.log(Level.SEVERE, thisClass, message);
    }

    public static void severe(Class<?> thisClass, Object message, Throwable t) {
        LoggingManager.log(Level.SEVERE, thisClass, message);
    }
}

