/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.core;

import com.paypal.core.HttpConfiguration;
import com.paypal.core.LoggingManager;
import com.paypal.exception.ClientActionRequiredException;
import com.paypal.exception.HttpErrorException;
import com.paypal.exception.InvalidResponseDataException;
import com.paypal.exception.SSLConfigurationException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpConnection {
    protected HttpConfiguration config;
    protected HttpURLConnection connection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(String url, String payload, Map<String, String> headers) throws InvalidResponseDataException, IOException, InterruptedException, HttpErrorException, ClientActionRequiredException {
        String successResponse = "";
        String errorResponse = "";
        int responsecode = -1;
        BufferedReader reader = null;
        OutputStreamWriter writer = null;
        this.connection.setRequestProperty("Content-Length", "" + payload.trim().length());
        if (headers != null) {
            LoggingManager.debug(HttpConnection.class, "curl command: ");
            LoggingManager.debug(HttpConnection.class, "curl -v '" + this.connection.getURL().toString() + "' \\");
            this.setHttpHeaders(headers);
            for (String key : headers.keySet()) {
                String value = headers.get(key);
                LoggingManager.debug(HttpConnection.class, "-H \"" + key + ": " + value + "\" \\");
            }
            LoggingManager.debug(HttpConnection.class, "-d '" + payload + "'");
        }
        try {
            int retry = 0;
            while (true) {
                try {
                    if ("POST".equalsIgnoreCase(this.connection.getRequestMethod())) {
                        writer = new OutputStreamWriter(this.connection.getOutputStream(), Charset.forName("UTF-8"));
                        writer.write(payload);
                        writer.flush();
                    }
                    responsecode = this.connection.getResponseCode();
                    reader = new BufferedReader(new InputStreamReader(this.connection.getInputStream(), "UTF-8"));
                    if (responsecode < 200 || responsecode >= 300) {
                        successResponse = this.read(reader);
                        throw new ClientActionRequiredException("Response Code : " + responsecode + " with response : " + successResponse);
                    }
                    successResponse = this.read(reader);
                    LoggingManager.debug(HttpConnection.class, "Response : " + successResponse);
                }
                catch (IOException e) {
                    try {
                        responsecode = this.connection.getResponseCode();
                        if (this.connection.getErrorStream() != null) {
                            reader = new BufferedReader(new InputStreamReader(this.connection.getErrorStream(), "UTF-8"));
                            errorResponse = this.read(reader);
                            LoggingManager.severe(HttpConnection.class, "Error code : " + responsecode + " with response : " + errorResponse);
                        }
                        if (errorResponse == null || errorResponse.length() == 0) {
                            errorResponse = e.getMessage();
                        }
                        if (responsecode <= 500) {
                            throw new HttpErrorException(responsecode, errorResponse, "Error code : " + responsecode + " with response : " + errorResponse, e);
                        }
                    }
                    catch (HttpErrorException ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        LoggingManager.severe(this.getClass(), "Caught exception while handling error response", ex);
                    }
                    if (++retry <= 0) continue;
                    LoggingManager.severe(HttpConnection.class, " Retry  No : " + retry + "...");
                    Thread.sleep(this.config.getRetryDelay());
                    if (retry < this.config.getMaxRetry()) continue;
                }
                break;
            }
            if (successResponse.trim().length() <= 0 && (responsecode < 200 || responsecode >= 300)) {
                throw new HttpErrorException("retry fails..  check log for more information");
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            finally {
                reader = null;
                writer = null;
            }
        }
        return successResponse;
    }

    public abstract void setupClientSSL(String var1, String var2) throws SSLConfigurationException;

    public abstract void createAndconfigureHttpConnection(HttpConfiguration var1) throws IOException;

    protected String read(BufferedReader reader) throws IOException {
        String inputLine = "";
        StringBuilder response = new StringBuilder();
        while ((inputLine = reader.readLine()) != null) {
            response.append(inputLine);
        }
        return response.toString();
    }

    protected void setHttpHeaders(Map<String, String> headers) {
        for (Map.Entry<String, String> pairs : headers.entrySet()) {
            String key = pairs.getKey();
            String value = pairs.getValue();
            this.connection.setRequestProperty(key, value);
        }
    }
}

