/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.core;

import com.paypal.core.AuthenticationStrategy;
import com.paypal.core.credential.SignatureCredential;
import com.paypal.core.credential.TokenAuthorization;
import com.paypal.sdk.exceptions.OAuthException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSignatureHttpHeaderAuthStrategy
implements AuthenticationStrategy<Map<String, String>, SignatureCredential> {
    protected String endPointUrl;

    public AbstractSignatureHttpHeaderAuthStrategy(String endPointUrl) {
        this.endPointUrl = endPointUrl;
    }

    @Override
    public Map<String, String> generateHeaderStrategy(SignatureCredential credential) throws OAuthException {
        HashMap<String, String> headers = null;
        if (credential.getThirdPartyAuthorization() instanceof TokenAuthorization) {
            headers = this.processTokenAuthorization(credential, (TokenAuthorization)credential.getThirdPartyAuthorization());
        } else {
            headers = new HashMap<String, String>();
            headers.put("X-PAYPAL-SECURITY-USERID", credential.getUserName());
            headers.put("X-PAYPAL-SECURITY-PASSWORD", credential.getPassword());
            headers.put("X-PAYPAL-SECURITY-SIGNATURE", credential.getSignature());
        }
        return headers;
    }

    protected abstract Map<String, String> processTokenAuthorization(SignatureCredential var1, TokenAuthorization var2) throws OAuthException;
}

