/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.corepayments;

import androidx.annotation.RestrictTo;
import com.paypal.android.corepayments.APIRequest;
import com.paypal.android.corepayments.Base64Kt;
import com.paypal.android.corepayments.CoreConfig;
import com.paypal.android.corepayments.Http;
import com.paypal.android.corepayments.HttpMethod;
import com.paypal.android.corepayments.HttpRequest;
import com.paypal.android.corepayments.HttpResponse;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B#\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0086@\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/paypal/android/corepayments/RestClient;", "", "configuration", "Lcom/paypal/android/corepayments/CoreConfig;", "(Lcom/paypal/android/corepayments/CoreConfig;)V", "http", "Lcom/paypal/android/corepayments/Http;", "language", "", "(Lcom/paypal/android/corepayments/CoreConfig;Lcom/paypal/android/corepayments/Http;Ljava/lang/String;)V", "createHttpRequestFromAPIRequest", "Lcom/paypal/android/corepayments/HttpRequest;", "apiRequest", "Lcom/paypal/android/corepayments/APIRequest;", "send", "Lcom/paypal/android/corepayments/HttpResponse;", "(Lcom/paypal/android/corepayments/APIRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "CorePayments_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class RestClient {
    @NotNull
    private final CoreConfig configuration;
    @NotNull
    private final Http http;
    @NotNull
    private final String language;

    public RestClient(@NotNull CoreConfig configuration, @NotNull Http http, @NotNull String language) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        this.configuration = configuration;
        this.http = http;
        this.language = language;
    }

    public /* synthetic */ RestClient(CoreConfig coreConfig, Http http, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            http = new Http(null, null, 3, null);
        }
        if ((n & 4) != 0) {
            String string2 = Locale.getDefault().getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLanguage(...)");
            string = string2;
        }
        this(coreConfig, http, string);
    }

    public RestClient(@NotNull CoreConfig configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this(configuration, new Http(null, null, 3, null), null, 4, null);
    }

    @Nullable
    public final Object send(@NotNull APIRequest apiRequest, @NotNull Continuation<? super HttpResponse> $completion) {
        HttpRequest httpRequest = this.createHttpRequestFromAPIRequest(apiRequest, this.configuration);
        return this.http.send(httpRequest, $completion);
    }

    private final HttpRequest createHttpRequestFromAPIRequest(APIRequest apiRequest, CoreConfig configuration) {
        String path = apiRequest.getPath();
        String baseUrl = configuration.getEnvironment().getUrl$CorePayments_release();
        URL url = new URL(baseUrl + '/' + path);
        HttpMethod method = apiRequest.getMethod();
        String body = apiRequest.getBody();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Accept-Encoding", (Object)"gzip"), TuplesKt.to((Object)"Accept-Language", (Object)this.language)};
        Map headers = MapsKt.mutableMapOf((Pair[])pairArray);
        String credentials = configuration.getClientId() + ':';
        headers.put("Authorization", "Basic " + Base64Kt.base64encoded(credentials));
        if (method == HttpMethod.POST) {
            headers.put("Content-Type", "application/json");
        }
        return new HttpRequest(url, method, body, headers);
    }
}

