/*
 * Decompiled with CFR 0.152.
 */
package com.paymennt.crypto.lib;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class BitsConverter {
    public static List<Integer> convertBits(byte[] key, int fromBits, int toBits, boolean pad) {
        BigInteger acc = BigInteger.ZERO;
        BigInteger bits = BigInteger.ZERO;
        ArrayList<Integer> result = new ArrayList<Integer>();
        BigInteger maxValue = BigInteger.ONE.shiftLeft(toBits).subtract(BigInteger.ONE);
        BigInteger maxAcc = BigInteger.ONE.shiftLeft(fromBits + toBits - 1).subtract(BigInteger.ONE);
        for (byte b : key) {
            int bi = Byte.toUnsignedInt(b);
            if (bi >> fromBits != 0) {
                return null;
            }
            acc = acc.shiftLeft(fromBits).xor(BigInteger.valueOf(bi)).and(maxAcc);
            bits = bits.add(BigInteger.valueOf(fromBits));
            while (bits.compareTo(BigInteger.valueOf(toBits)) >= 0) {
                bits = bits.subtract(BigInteger.valueOf(toBits));
                result.add(acc.shiftRight(bits.intValueExact()).and(maxValue).intValueExact());
            }
        }
        if (pad && !bits.equals(BigInteger.ZERO)) {
            result.add(acc.shiftLeft(toBits - bits.intValueExact()).and(maxValue).intValueExact());
        }
        if (!(pad || bits.compareTo(BigInteger.valueOf(fromBits)) < 0 && acc.shiftLeft(BigInteger.valueOf(toBits).subtract(bits).intValueExact()).and(maxValue).equals(BigInteger.ZERO))) {
            return null;
        }
        return result;
    }

    public static List<Integer> convertBits(List<Integer> key, int fromBits, int toBits, boolean pad) {
        BigInteger acc = BigInteger.ZERO;
        BigInteger bits = BigInteger.ZERO;
        ArrayList<Integer> result = new ArrayList<Integer>();
        BigInteger maxValue = BigInteger.ONE.shiftLeft(toBits).subtract(BigInteger.ONE);
        BigInteger maxAcc = BigInteger.ONE.shiftLeft(fromBits + toBits - 1).subtract(BigInteger.ONE);
        for (int bi : key) {
            if (bi >> fromBits != 0) {
                return null;
            }
            acc = acc.shiftLeft(fromBits).xor(BigInteger.valueOf(bi)).and(maxAcc);
            bits = bits.add(BigInteger.valueOf(fromBits));
            while (bits.compareTo(BigInteger.valueOf(toBits)) >= 0) {
                bits = bits.subtract(BigInteger.valueOf(toBits));
                result.add(acc.shiftRight(bits.intValueExact()).and(maxValue).intValueExact());
            }
        }
        if (pad && !bits.equals(BigInteger.ZERO)) {
            result.add(acc.shiftLeft(toBits - bits.intValueExact()).and(maxValue).intValueExact());
        }
        if (!(pad || bits.compareTo(BigInteger.valueOf(fromBits)) < 0 && acc.shiftLeft(BigInteger.valueOf(toBits).subtract(bits).intValueExact()).and(maxValue).equals(BigInteger.ZERO))) {
            return null;
        }
        return result;
    }
}

