/*
 * Decompiled with CFR 0.152.
 */
package com.paymennt.crypto.bip39;

import com.paymennt.crypto.bip39.WordList;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class MnemonicGenerator {
    public static final String SPACE_JP = "\u3000";

    public static byte[] getSeedFromWordlist(String words, String password) {
        String[] wordsList;
        if (password == null) {
            password = "";
        }
        if ((wordsList = words.split(" ")).length < 12) {
            throw new IllegalArgumentException("Must be at least 12 words");
        }
        if (wordsList.length > 24) {
            throw new IllegalArgumentException("Must be less than 24 words");
        }
        for (String word : wordsList) {
            if (WordList.ENGLISH.getWordIndex(word.trim().toCharArray()) >= 0) continue;
            throw new IllegalArgumentException("Unknown word: " + word);
        }
        String salt = "mnemonic" + password;
        return MnemonicGenerator.pbkdf2HmacSha512(words.trim().toCharArray(), salt.getBytes(StandardCharsets.UTF_8), 2048, 512);
    }

    private static byte[] pbkdf2HmacSha512(char[] password, byte[] salt, int iterations, int keyLength) {
        try {
            SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
            PBEKeySpec spec = new PBEKeySpec(password, salt, iterations, keyLength);
            SecretKey key = skf.generateSecret(spec);
            byte[] res = key.getEncoded();
            return res;
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }
}

