/*
 * Decompiled with CFR 0.152.
 */
package com.paymennt.crypto.bip32.wallet;

import com.paymennt.crypto.CoinType;
import com.paymennt.crypto.bip32.Network;
import com.paymennt.crypto.bip32.wallet.HdAddress;
import com.paymennt.crypto.bip32.wallet.HdKeyGenerator;
import com.paymennt.crypto.bip32.wallet.key.HdPrivateKey;
import com.paymennt.crypto.bip32.wallet.key.HdPublicKey;
import com.paymennt.crypto.bip39.MnemonicGenerator;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public abstract class AbstractWallet {
    private HdAddress rootAddress;

    protected AbstractWallet(String words, String passphrase, Purpose purpose, Network network, CoinType coinType) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        byte[] seed = MnemonicGenerator.getSeedFromWordlist(words, passphrase);
        HdAddress masterAddress = HdKeyGenerator.getAddressFromSeed(seed, network, coinType);
        HdAddress purposeAddress = HdKeyGenerator.getAddress(masterAddress, purpose.bip, true);
        this.rootAddress = HdKeyGenerator.getAddress(purposeAddress, coinType.getCoinType(network), true);
    }

    protected HdAddress getHdAddress(int account, Chain chain, Integer index) {
        HdAddress accountAddress = HdKeyGenerator.getAddress(this.rootAddress, account, true);
        HdAddress chainAddress = HdKeyGenerator.getAddress(accountAddress, chain.getChainCode(), this.rootAddress.getCoinType().getAlwaysHardened());
        if (index == null) {
            return chainAddress;
        }
        return HdKeyGenerator.getAddress(chainAddress, index.intValue(), this.rootAddress.getCoinType().getAlwaysHardened());
    }

    public HdPrivateKey getPrivateKey(int account, Chain chain, Integer index) {
        return this.getHdAddress(account, chain, index).getPrivateKey();
    }

    public HdPublicKey getPublicKey(int account, Chain chain, Integer index) {
        return this.getHdAddress(account, chain, index).getPublicKey();
    }

    public String getPath(int account, Chain chain, Integer index) {
        return this.getHdAddress(account, chain, index).getPath();
    }

    public abstract String getAddress(int var1, Chain var2, Integer var3);

    public static enum Purpose {
        BIP44(44),
        BIP49(49),
        BIP84(84);

        private final int bip;

        private Purpose(int bip) {
            this.bip = bip;
        }

        public int getBip() {
            return this.bip;
        }

        public static Purpose getPurposeForBip(int bip) {
            for (Purpose purpose : Purpose.values()) {
                if (purpose.bip != bip) continue;
                return purpose;
            }
            return null;
        }
    }

    public static enum Chain {
        EXTERNAL(0),
        CHANGE(1);

        private final int chainCode;

        private Chain(int chainCode) {
            this.chainCode = chainCode;
        }

        public int getChainCode() {
            return this.chainCode;
        }

        protected static Chain getChainForChainCode(int chainCode) {
            for (Chain chain : Chain.values()) {
                if (chain.chainCode != chainCode) continue;
                return chain;
            }
            return null;
        }
    }
}

