/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Continuation;
import bolts.Task;
import com.parse.GetCallback;
import com.parse.ParseClassName;
import com.parse.ParseCorePlugins;
import com.parse.ParseObject;
import com.parse.ParseQuery;
import com.parse.ParseSessionController;
import com.parse.ParseTaskUtils;
import com.parse.ParseUser;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@ParseClassName(value="_Session")
public class ParseSession
extends ParseObject {
    private static final String KEY_SESSION_TOKEN = "sessionToken";
    private static final String KEY_CREATED_WITH = "createdWith";
    private static final String KEY_RESTRICTED = "restricted";
    private static final String KEY_USER = "user";
    private static final String KEY_EXPIRES_AT = "expiresAt";
    private static final String KEY_INSTALLATION_ID = "installationId";
    private static final List<String> READ_ONLY_KEYS = Collections.unmodifiableList(Arrays.asList("sessionToken", "createdWith", "restricted", "user", "expiresAt", "installationId"));

    private static ParseSessionController getSessionController() {
        return ParseCorePlugins.getInstance().getSessionController();
    }

    public static Task<ParseSession> getCurrentSessionInBackground() {
        return ParseUser.getCurrentSessionTokenAsync().onSuccessTask((Continuation)new Continuation<String, Task<ParseSession>>(){

            public Task<ParseSession> then(Task<String> task) throws Exception {
                String sessionToken = (String)task.getResult();
                if (sessionToken == null) {
                    return Task.forResult(null);
                }
                return ParseSession.getSessionController().getSessionAsync(sessionToken).onSuccess((Continuation)new Continuation<ParseObject.State, ParseSession>(){

                    public ParseSession then(Task<ParseObject.State> task) throws Exception {
                        ParseObject.State result = (ParseObject.State)task.getResult();
                        return (ParseSession)ParseObject.from(result);
                    }
                });
            }
        });
    }

    public static void getCurrentSessionInBackground(GetCallback<ParseSession> callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseSession.getCurrentSessionInBackground(), callback);
    }

    static Task<Void> revokeAsync(String sessionToken) {
        if (sessionToken == null || !ParseSession.isRevocableSessionToken(sessionToken)) {
            return Task.forResult(null);
        }
        return ParseSession.getSessionController().revokeAsync(sessionToken);
    }

    static Task<String> upgradeToRevocableSessionAsync(String sessionToken) {
        if (sessionToken == null || ParseSession.isRevocableSessionToken(sessionToken)) {
            return Task.forResult((Object)sessionToken);
        }
        return ParseSession.getSessionController().upgradeToRevocable(sessionToken).onSuccess((Continuation)new Continuation<ParseObject.State, String>(){

            public String then(Task<ParseObject.State> task) throws Exception {
                ParseObject.State result = (ParseObject.State)task.getResult();
                return ((ParseSession)ParseObject.from(result)).getSessionToken();
            }
        });
    }

    static boolean isRevocableSessionToken(String sessionToken) {
        return sessionToken.contains("r:");
    }

    public static ParseQuery<ParseSession> getQuery() {
        return ParseQuery.getQuery(ParseSession.class);
    }

    @Override
    boolean needsDefaultACL() {
        return false;
    }

    @Override
    boolean isKeyMutable(String key) {
        return !READ_ONLY_KEYS.contains(key);
    }

    public String getSessionToken() {
        return this.getString(KEY_SESSION_TOKEN);
    }
}

