/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.ParseByteArrayHttpBody;
import com.parse.ParseCountingByteArrayHttpBody;
import com.parse.ParseCountingFileHttpBody;
import com.parse.ParseFileHttpBody;
import com.parse.ParseRESTCommand;
import com.parse.ProgressCallback;
import com.parse.http.ParseHttpBody;
import com.parse.http.ParseHttpRequest;
import java.io.File;

class ParseRESTFileCommand
extends ParseRESTCommand {
    private final byte[] data;
    private final String contentType;
    private final File file;

    public ParseRESTFileCommand(Builder builder) {
        super(builder);
        if (builder.file != null && builder.data != null) {
            throw new IllegalArgumentException("File and data can not be set at the same time");
        }
        this.data = builder.data;
        this.contentType = builder.contentType;
        this.file = builder.file;
    }

    @Override
    protected ParseHttpBody newBody(ProgressCallback progressCallback) {
        if (progressCallback == null) {
            return this.data != null ? new ParseByteArrayHttpBody(this.data, this.contentType) : new ParseFileHttpBody(this.file, this.contentType);
        }
        return this.data != null ? new ParseCountingByteArrayHttpBody(this.data, this.contentType, progressCallback) : new ParseCountingFileHttpBody(this.file, this.contentType, progressCallback);
    }

    public static class Builder
    extends ParseRESTCommand.Init<Builder> {
        private byte[] data = null;
        private String contentType = null;
        private File file;

        public Builder() {
            this.method(ParseHttpRequest.Method.POST);
        }

        public Builder fileName(String fileName) {
            return (Builder)this.httpPath(String.format("files/%s", fileName));
        }

        public Builder data(byte[] data) {
            this.data = data;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder file(File file) {
            this.file = file;
            return this;
        }

        @Override
        Builder self() {
            return this;
        }

        public ParseRESTFileCommand build() {
            return new ParseRESTFileCommand(this);
        }
    }
}

