/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.net.Uri;
import com.parse.NoObjectsEncoder;
import com.parse.ParseRESTCommand;
import com.parse.http.ParseHttpRequest;
import java.util.Date;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class ParseRESTAnalyticsCommand
extends ParseRESTCommand {
    static final String EVENT_APP_OPENED = "AppOpened";
    private static final String PATH = "events/%s";
    private static final String KEY_AT = "at";
    private static final String KEY_PUSH_HASH = "push_hash";
    private static final String KEY_DIMENSIONS = "dimensions";

    public static ParseRESTAnalyticsCommand trackAppOpenedCommand(String pushHash, String sessionToken) {
        return ParseRESTAnalyticsCommand.trackEventCommand(EVENT_APP_OPENED, pushHash, null, sessionToken);
    }

    public static ParseRESTAnalyticsCommand trackEventCommand(String eventName, Map<String, String> dimensions, String sessionToken) {
        return ParseRESTAnalyticsCommand.trackEventCommand(eventName, null, dimensions, sessionToken);
    }

    static ParseRESTAnalyticsCommand trackEventCommand(String eventName, String pushHash, Map<String, String> dimensions, String sessionToken) {
        String httpPath = String.format(PATH, Uri.encode((String)eventName));
        JSONObject parameters = new JSONObject();
        try {
            parameters.put(KEY_AT, NoObjectsEncoder.get().encode(new Date()));
            if (pushHash != null) {
                parameters.put(KEY_PUSH_HASH, (Object)pushHash);
            }
            if (dimensions != null) {
                parameters.put(KEY_DIMENSIONS, NoObjectsEncoder.get().encode(dimensions));
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return new ParseRESTAnalyticsCommand(httpPath, ParseHttpRequest.Method.POST, parameters, sessionToken);
    }

    public ParseRESTAnalyticsCommand(String httpPath, ParseHttpRequest.Method httpMethod, JSONObject parameters, String sessionToken) {
        super(httpPath, httpMethod, parameters, sessionToken);
    }
}

