/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.os.Parcel;
import com.parse.ParseACL;
import com.parse.ParseDateFormat;
import com.parse.ParseFieldOperations;
import com.parse.ParseFile;
import com.parse.ParseGeoPoint;
import com.parse.ParseObject;
import com.parse.ParseRelation;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONObject;

class ParseParcelDecoder {
    private static final ParseParcelDecoder INSTANCE = new ParseParcelDecoder();

    ParseParcelDecoder() {
    }

    public static ParseParcelDecoder get() {
        return INSTANCE;
    }

    public Object decode(Parcel source) {
        String type;
        switch (type = source.readString()) {
            case "Object": {
                return this.decodeParseObject(source);
            }
            case "Pointer": {
                return this.decodePointer(source);
            }
            case "Date": {
                String iso = source.readString();
                return ParseDateFormat.getInstance().parse(iso);
            }
            case "Bytes": {
                byte[] bytes = new byte[source.readInt()];
                source.readByteArray(bytes);
                return bytes;
            }
            case "Operation": {
                return ParseFieldOperations.decode(source, this);
            }
            case "File": {
                return new ParseFile(source, this);
            }
            case "GeoPoint": {
                return new ParseGeoPoint(source, this);
            }
            case "Acl": {
                return new ParseACL(source, this);
            }
            case "Relation": {
                return new ParseRelation(source, this);
            }
            case "Map": {
                int size = source.readInt();
                HashMap<String, Object> map = new HashMap<String, Object>(size);
                for (int i = 0; i < size; ++i) {
                    map.put(source.readString(), this.decode(source));
                }
                return map;
            }
            case "Collection": {
                int length = source.readInt();
                ArrayList<Object> list = new ArrayList<Object>(length);
                for (int i = 0; i < length; ++i) {
                    list.add(i, this.decode(source));
                }
                return list;
            }
            case "JsonNull": {
                return JSONObject.NULL;
            }
            case "Null": {
                return null;
            }
            case "Native": {
                return source.readValue(null);
            }
        }
        throw new RuntimeException("Could not unparcel objects from this Parcel.");
    }

    protected ParseObject decodeParseObject(Parcel source) {
        return ParseObject.createFromParcel(source, this);
    }

    protected ParseObject decodePointer(Parcel source) {
        return ParseObject.createWithoutData(source.readString(), source.readString());
    }
}

