/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.ParseClassName;
import com.parse.ParseInstallation;
import com.parse.ParseObject;
import com.parse.ParseUser;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

class ParseObjectSubclassingController {
    private final Object mutex = new Object();
    private final Map<String, Constructor<? extends ParseObject>> registeredSubclasses = new HashMap<String, Constructor<? extends ParseObject>>();

    ParseObjectSubclassingController() {
    }

    String getClassName(Class<? extends ParseObject> clazz) {
        ParseClassName info = clazz.getAnnotation(ParseClassName.class);
        if (info == null) {
            throw new IllegalArgumentException("No ParseClassName annotation provided on " + clazz);
        }
        return info.value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isSubclassValid(String className, Class<? extends ParseObject> clazz) {
        Constructor<? extends ParseObject> constructor = null;
        Object object = this.mutex;
        synchronized (object) {
            constructor = this.registeredSubclasses.get(className);
        }
        return constructor == null ? clazz == ParseObject.class : constructor.getDeclaringClass() == clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerSubclass(Class<? extends ParseObject> clazz) {
        if (!ParseObject.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Cannot register a type that is not a subclass of ParseObject");
        }
        String className = this.getClassName(clazz);
        Constructor<? extends ParseObject> previousConstructor = null;
        Object object = this.mutex;
        synchronized (object) {
            previousConstructor = this.registeredSubclasses.get(className);
            if (previousConstructor != null) {
                Class<? extends ParseObject> previousClass = previousConstructor.getDeclaringClass();
                if (clazz.isAssignableFrom(previousClass)) {
                    return;
                }
                if (!previousClass.isAssignableFrom(clazz)) {
                    throw new IllegalArgumentException("Tried to register both " + previousClass.getName() + " and " + clazz.getName() + " as the ParseObject subclass of " + className + ". " + "Cannot determine the right " + "class to use because neither inherits from the other.");
                }
            }
            try {
                this.registeredSubclasses.put(className, ParseObjectSubclassingController.getConstructor(clazz));
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalArgumentException("Cannot register a type that does not implement the default constructor!");
            }
            catch (IllegalAccessException ex) {
                throw new IllegalArgumentException("Default constructor for " + clazz + " is not accessible.");
            }
        }
        if (previousConstructor != null) {
            if (className.equals(this.getClassName(ParseUser.class))) {
                ParseUser.getCurrentUserController().clearFromMemory();
            } else if (className.equals(this.getClassName(ParseInstallation.class))) {
                ParseInstallation.getCurrentInstallationController().clearFromMemory();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterSubclass(Class<? extends ParseObject> clazz) {
        String className = this.getClassName(clazz);
        Object object = this.mutex;
        synchronized (object) {
            this.registeredSubclasses.remove(className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ParseObject newInstance(String className) {
        Constructor<? extends ParseObject> constructor = null;
        Object object = this.mutex;
        synchronized (object) {
            constructor = this.registeredSubclasses.get(className);
        }
        try {
            return constructor != null ? constructor.newInstance(new Object[0]) : new ParseObject(className);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create instance of subclass.", e);
        }
    }

    private static Constructor<? extends ParseObject> getConstructor(Class<? extends ParseObject> clazz) throws NoSuchMethodException, IllegalAccessException {
        Constructor<? extends ParseObject> constructor = clazz.getDeclaredConstructor(new Class[0]);
        if (constructor == null) {
            throw new NoSuchMethodException();
        }
        int modifiers = constructor.getModifiers();
        if (Modifier.isPublic(modifiers) || clazz.getPackage().getName().equals("com.parse") && !Modifier.isProtected(modifiers) && !Modifier.isPrivate(modifiers)) {
            return constructor;
        }
        throw new IllegalAccessException();
    }
}

