/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import android.content.Intent;
import bolts.Capture;
import bolts.Continuation;
import bolts.Task;
import bolts.TaskCompletionSource;
import com.parse.ConnectivityNotifier;
import com.parse.Parse;
import com.parse.ParseCorePlugins;
import com.parse.ParseEventuallyQueue;
import com.parse.ParseException;
import com.parse.ParseExecutors;
import com.parse.ParseFileUtils;
import com.parse.ParseHttpClient;
import com.parse.ParseObject;
import com.parse.ParseRESTCommand;
import com.parse.ParseTaskUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

class ParseCommandCache
extends ParseEventuallyQueue {
    private static final String TAG = "com.parse.ParseCommandCache";
    private static int filenameCounter = 0;
    private static final Object lock = new Object();
    private File cachePath;
    private int timeoutMaxRetries = 5;
    private double timeoutRetryWaitSeconds = 600.0;
    private int maxCacheSizeBytes = 0xA00000;
    private boolean shouldStop;
    private boolean unprocessedCommandsExist;
    private HashMap<File, TaskCompletionSource<JSONObject>> pendingTasks = new HashMap();
    private boolean running;
    private final Object runningLock;
    private Logger log;
    private final ParseHttpClient httpClient;
    ConnectivityNotifier notifier;
    ConnectivityNotifier.ConnectivityListener listener = new ConnectivityNotifier.ConnectivityListener(){

        @Override
        public void networkConnectivityStatusChanged(Context context, Intent intent) {
            final boolean connectionLost = intent.getBooleanExtra("noConnectivity", false);
            final boolean isConnected = ConnectivityNotifier.isConnected(context);
            Task.call((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (connectionLost) {
                        ParseCommandCache.this.setConnected(false);
                    } else {
                        ParseCommandCache.this.setConnected(isConnected);
                    }
                    return null;
                }
            }, (Executor)ParseExecutors.io());
        }
    };

    private static File getCacheDir() {
        File cacheDir = new File(Parse.getParseDir(), "CommandCache");
        cacheDir.mkdirs();
        return cacheDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getPendingCount() {
        Object object = lock;
        synchronized (object) {
            String[] files = ParseCommandCache.getCacheDir().list();
            return files == null ? 0 : files.length;
        }
    }

    public ParseCommandCache(Context context, ParseHttpClient client) {
        this.setConnected(false);
        this.shouldStop = false;
        this.running = false;
        this.runningLock = new Object();
        this.httpClient = client;
        this.log = Logger.getLogger(TAG);
        this.cachePath = ParseCommandCache.getCacheDir();
        if (!Parse.hasPermission("android.permission.ACCESS_NETWORK_STATE")) {
            return;
        }
        this.setConnected(ConnectivityNotifier.isConnected(context));
        this.notifier = ConnectivityNotifier.getNotifier(context);
        this.notifier.addListener(this.listener);
        this.resume();
    }

    @Override
    public void onDestroy() {
        this.notifier.removeListener(this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeoutMaxRetries(int tries) {
        Object object = lock;
        synchronized (object) {
            this.timeoutMaxRetries = tries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimeoutRetryWaitSeconds(double seconds) {
        Object object = lock;
        synchronized (object) {
            this.timeoutRetryWaitSeconds = seconds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxCacheSizeBytes(int bytes) {
        Object object = lock;
        synchronized (object) {
            this.maxCacheSizeBytes = bytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        Object object = this.runningLock;
        synchronized (object) {
            if (!this.running) {
                new Thread("ParseCommandCache.runLoop()"){

                    @Override
                    public void run() {
                        ParseCommandCache.this.runLoop();
                    }
                }.start();
                try {
                    this.runningLock.wait();
                }
                catch (InterruptedException e) {
                    Object object2 = lock;
                    synchronized (object2) {
                        this.shouldStop = true;
                        lock.notifyAll();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        Object object = this.runningLock;
        synchronized (object) {
            if (this.running) {
                Object object2 = lock;
                synchronized (object2) {
                    this.shouldStop = true;
                    lock.notifyAll();
                }
            }
            while (this.running) {
                try {
                    this.runningLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFile(File file) {
        Object object = lock;
        synchronized (object) {
            this.pendingTasks.remove(file);
            try {
                JSONObject json = ParseFileUtils.readFileToJSONObject(file);
                ParseRESTCommand command = this.commandFromJSON(json);
                command.releaseLocalIds();
            }
            catch (Exception e) {
                // empty catch block
            }
            ParseFileUtils.deleteQuietly(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void simulateReboot() {
        Object object = lock;
        synchronized (object) {
            this.pendingTasks.clear();
        }
    }

    @Override
    void fakeObjectUpdate() {
        this.notifyTestHelper(3);
        this.notifyTestHelper(1);
        this.notifyTestHelper(5);
    }

    @Override
    public Task<JSONObject> enqueueEventuallyAsync(ParseRESTCommand command, ParseObject object) {
        return this.enqueueEventuallyAsync(command, false, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Task<JSONObject> enqueueEventuallyAsync(ParseRESTCommand command, boolean preferOldest, ParseObject object) {
        byte[] json;
        Parse.requirePermission("android.permission.ACCESS_NETWORK_STATE");
        TaskCompletionSource tcs = new TaskCompletionSource();
        try {
            if (object != null && object.getObjectId() == null) {
                command.setLocalId(object.getOrCreateLocalId());
            }
            JSONObject jsonObject = command.toJSONObject();
            json = jsonObject.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            if (5 >= Parse.getLogLevel()) {
                this.log.log(Level.WARNING, "UTF-8 isn't supported.  This shouldn't happen.", e);
            }
            this.notifyTestHelper(4);
            return Task.forResult(null);
        }
        if (json.length > this.maxCacheSizeBytes) {
            if (5 >= Parse.getLogLevel()) {
                this.log.warning("Unable to save command for later because it's too big.");
            }
            this.notifyTestHelper(4);
            return Task.forResult(null);
        }
        Object object2 = lock;
        synchronized (object2) {
            try {
                String prefix2;
                String prefix1;
                Task fileNames = this.cachePath.list();
                if (fileNames != null) {
                    File file;
                    Arrays.sort((Object[])fileNames);
                    int size = 0;
                    Task task = fileNames;
                    int n = ((Object[])task).length;
                    for (int i = 0; i < n; size += (int)file.length(), ++i) {
                        Object fileName = task[i];
                        file = new File(this.cachePath, (String)fileName);
                    }
                    if ((size += json.length) > this.maxCacheSizeBytes) {
                        if (preferOldest) {
                            if (5 >= Parse.getLogLevel()) {
                                this.log.warning("Unable to save command for later because storage is full.");
                            }
                            task = Task.forResult(null);
                            return task;
                        }
                        if (5 >= Parse.getLogLevel()) {
                            this.log.warning("Deleting old commands to make room in command cache.");
                        }
                        int indexToDelete = 0;
                        while (size > this.maxCacheSizeBytes && indexToDelete < ((Task)fileNames).length) {
                            File file2 = new File(this.cachePath, (String)fileNames[indexToDelete++]);
                            size -= (int)file2.length();
                            this.removeFile(file2);
                        }
                    }
                }
                if ((prefix1 = Long.toHexString(System.currentTimeMillis())).length() < 16) {
                    char[] zeroes = new char[16 - prefix1.length()];
                    Arrays.fill(zeroes, '0');
                    prefix1 = new String(zeroes) + prefix1;
                }
                if ((prefix2 = Integer.toHexString(filenameCounter++)).length() < 8) {
                    char[] zeroes = new char[8 - prefix2.length()];
                    Arrays.fill(zeroes, '0');
                    prefix2 = new String(zeroes) + prefix2;
                }
                String prefix = "CachedCommand_" + prefix1 + "_" + prefix2 + "_";
                File path = File.createTempFile(prefix, "", this.cachePath);
                this.pendingTasks.put(path, (TaskCompletionSource<JSONObject>)tcs);
                command.retainLocalIds();
                ParseFileUtils.writeByteArrayToFile(path, json);
                this.notifyTestHelper(3);
                this.unprocessedCommandsExist = true;
            }
            catch (IOException e) {
                if (5 < Parse.getLogLevel()) return tcs.getTask();
                this.log.log(Level.WARNING, "Unable to save command for later.", e);
            }
            finally {
                lock.notifyAll();
            }
            return tcs.getTask();
        }
    }

    @Override
    public int pendingCount() {
        return ParseCommandCache.getPendingCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = lock;
        synchronized (object) {
            File[] files = this.cachePath.listFiles();
            if (files == null) {
                return;
            }
            for (File file : files) {
                this.removeFile(file);
            }
            this.pendingTasks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConnected(boolean connected) {
        Object object = lock;
        synchronized (object) {
            if (this.isConnected() != connected && connected) {
                lock.notifyAll();
            }
            super.setConnected(connected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T waitForTaskWithoutLock(Task<T> task) throws ParseException {
        Object object = lock;
        synchronized (object) {
            final Capture finished = new Capture((Object)false);
            task.continueWith(new Continuation<T, Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void then(Task<T> task) throws Exception {
                    finished.set((Object)true);
                    Object object = lock;
                    synchronized (object) {
                        lock.notifyAll();
                    }
                    return null;
                }
            }, (Executor)Task.BACKGROUND_EXECUTOR);
            while (!((Boolean)finished.get()).booleanValue()) {
                try {
                    lock.wait();
                }
                catch (InterruptedException ie) {
                    this.shouldStop = true;
                }
            }
            return ParseTaskUtils.wait(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeRunAllCommandsNow(int retriesRemaining) {
        Object object = lock;
        synchronized (object) {
            this.unprocessedCommandsExist = false;
            if (!this.isConnected()) {
                return;
            }
            Object[] fileNames = this.cachePath.list();
            if (fileNames == null || fileNames.length == 0) {
                return;
            }
            Arrays.sort(fileNames);
            for (Object fileName : fileNames) {
                ParseRESTCommand command;
                JSONObject json;
                File file = new File(this.cachePath, (String)fileName);
                try {
                    json = ParseFileUtils.readFileToJSONObject(file);
                }
                catch (FileNotFoundException e) {
                    if (6 < Parse.getLogLevel()) continue;
                    this.log.log(Level.SEVERE, "File disappeared from cache while being read.", e);
                    continue;
                }
                catch (IOException e) {
                    if (6 >= Parse.getLogLevel()) {
                        this.log.log(Level.SEVERE, "Unable to read contents of file in cache.", e);
                    }
                    this.removeFile(file);
                    continue;
                }
                catch (JSONException e) {
                    if (6 >= Parse.getLogLevel()) {
                        this.log.log(Level.SEVERE, "Error parsing JSON found in cache.", e);
                    }
                    this.removeFile(file);
                    continue;
                }
                final TaskCompletionSource<JSONObject> tcs = this.pendingTasks.containsKey(file) ? this.pendingTasks.get(file) : null;
                try {
                    command = this.commandFromJSON(json);
                }
                catch (JSONException e) {
                    if (6 >= Parse.getLogLevel()) {
                        this.log.log(Level.SEVERE, "Unable to create ParseCommand from JSON.", e);
                    }
                    this.removeFile(file);
                    continue;
                }
                try {
                    Task commandTask;
                    if (command == null) {
                        commandTask = Task.forResult(null);
                        if (tcs != null) {
                            tcs.setResult(null);
                        }
                        this.notifyTestHelper(8);
                    } else {
                        commandTask = command.executeAsync(this.httpClient).continueWithTask((Continuation)new Continuation<JSONObject, Task<JSONObject>>(){

                            public Task<JSONObject> then(Task<JSONObject> task) throws Exception {
                                String objectId;
                                String localId = command.getLocalId();
                                Exception error = task.getError();
                                if (error != null) {
                                    if (!(error instanceof ParseException && ((ParseException)error).getCode() == 100 || tcs == null)) {
                                        tcs.setError(error);
                                    }
                                    return task;
                                }
                                JSONObject json = (JSONObject)task.getResult();
                                if (tcs != null) {
                                    tcs.setResult((Object)json);
                                } else if (localId != null && (objectId = json.optString("objectId", null)) != null) {
                                    ParseCorePlugins.getInstance().getLocalIdManager().setObjectId(localId, objectId);
                                }
                                return task;
                            }
                        });
                    }
                    this.waitForTaskWithoutLock(commandTask);
                    if (tcs != null) {
                        this.waitForTaskWithoutLock(tcs.getTask());
                    }
                    this.removeFile(file);
                    this.notifyTestHelper(1);
                }
                catch (ParseException e) {
                    if (e.getCode() == 100) {
                        if (retriesRemaining > 0) {
                            if (4 >= Parse.getLogLevel()) {
                                this.log.info("Network timeout in command cache. Waiting for " + this.timeoutRetryWaitSeconds + " seconds and then retrying " + retriesRemaining + " times.");
                            }
                            long currentTime = System.currentTimeMillis();
                            long waitUntil = currentTime + (long)(this.timeoutRetryWaitSeconds * 1000.0);
                            while (currentTime < waitUntil) {
                                if (!this.isConnected() || this.shouldStop) {
                                    if (4 >= Parse.getLogLevel()) {
                                        this.log.info("Aborting wait because runEventually thread should stop.");
                                    }
                                    return;
                                }
                                try {
                                    lock.wait(waitUntil - currentTime);
                                }
                                catch (InterruptedException ie) {
                                    this.shouldStop = true;
                                }
                                if ((currentTime = System.currentTimeMillis()) >= waitUntil - (long)(this.timeoutRetryWaitSeconds * 1000.0)) continue;
                                currentTime = waitUntil - (long)(this.timeoutRetryWaitSeconds * 1000.0);
                            }
                            this.maybeRunAllCommandsNow(retriesRemaining - 1);
                            continue;
                        }
                        this.setConnected(false);
                        this.notifyTestHelper(7);
                        continue;
                    }
                    if (6 >= Parse.getLogLevel()) {
                        this.log.log(Level.SEVERE, "Failed to run command.", e);
                    }
                    this.removeFile(file);
                    this.notifyTestHelper(2, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void runLoop() {
        if (4 >= Parse.getLogLevel()) {
            this.log.info("Parse command cache has started processing queued commands.");
        }
        Object object = this.runningLock;
        // MONITORENTER : object
        if (this.running) {
            // MONITOREXIT : object
            return;
        }
        this.running = true;
        this.runningLock.notifyAll();
        // MONITOREXIT : object
        Object object2 = lock;
        // MONITORENTER : object2
        boolean shouldRun = !this.shouldStop && !Thread.interrupted();
        // MONITOREXIT : object2
        while (true) {
            if (!shouldRun) {
                object2 = this.runningLock;
                // MONITORENTER : object2
                this.running = false;
                this.runningLock.notifyAll();
                // MONITOREXIT : object2
                if (4 < Parse.getLogLevel()) return;
                this.log.info("saveEventually thread has stopped processing commands.");
                return;
            }
            object2 = lock;
            // MONITORENTER : object2
            try {
                this.maybeRunAllCommandsNow(this.timeoutMaxRetries);
                if (!this.shouldStop) {
                    try {
                        if (!this.unprocessedCommandsExist) {
                            lock.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        this.shouldStop = true;
                    }
                }
                shouldRun = !this.shouldStop;
            }
            catch (Exception e) {
                try {
                    if (6 >= Parse.getLogLevel()) {
                        this.log.log(Level.SEVERE, "saveEventually thread had an error.", e);
                    }
                    shouldRun = !this.shouldStop;
                }
                catch (Throwable throwable) {
                    shouldRun = !this.shouldStop;
                    throw throwable;
                }
            }
            // MONITOREXIT : object2
        }
    }
}

