/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Intent;
import bolts.Capture;
import bolts.Continuation;
import bolts.Task;
import com.parse.PLog;
import com.parse.ParseAnalyticsController;
import com.parse.ParseCorePlugins;
import com.parse.ParseTaskUtils;
import com.parse.ParseUser;
import com.parse.SaveCallback;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class ParseAnalytics {
    private static final String TAG = "com.parse.ParseAnalytics";
    private static final Map<String, Boolean> lruSeenPushes = new LinkedHashMap<String, Boolean>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Boolean> eldest) {
            return this.size() > 10;
        }
    };

    static ParseAnalyticsController getAnalyticsController() {
        return ParseCorePlugins.getInstance().getAnalyticsController();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Task<Void> trackAppOpenedInBackground(Intent intent) {
        String pushHashStr = ParseAnalytics.getPushHashFromIntent(intent);
        final Capture pushHash = new Capture();
        if (pushHashStr != null && pushHashStr.length() > 0) {
            Map<String, Boolean> map = lruSeenPushes;
            synchronized (map) {
                if (lruSeenPushes.containsKey(pushHashStr)) {
                    return Task.forResult(null);
                }
                lruSeenPushes.put(pushHashStr, true);
                pushHash.set((Object)pushHashStr);
            }
        }
        return ParseUser.getCurrentSessionTokenAsync().onSuccessTask((Continuation)new Continuation<String, Task<Void>>(){

            public Task<Void> then(Task<String> task) throws Exception {
                String sessionToken = (String)task.getResult();
                return ParseAnalytics.getAnalyticsController().trackAppOpenedInBackground((String)pushHash.get(), sessionToken);
            }
        });
    }

    @Deprecated
    public static void trackAppOpened(Intent intent) {
        ParseAnalytics.trackAppOpenedInBackground(intent);
    }

    public static void trackAppOpenedInBackground(Intent intent, SaveCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseAnalytics.trackAppOpenedInBackground(intent), callback);
    }

    @Deprecated
    public static void trackEvent(String name) {
        ParseAnalytics.trackEventInBackground(name);
    }

    public static void trackEventInBackground(String name, SaveCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseAnalytics.trackEventInBackground(name), callback);
    }

    @Deprecated
    public static void trackEvent(String name, Map<String, String> dimensions) {
        ParseAnalytics.trackEventInBackground(name, dimensions);
    }

    public static void trackEventInBackground(String name, Map<String, String> dimensions, SaveCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseAnalytics.trackEventInBackground(name, dimensions), callback);
    }

    public static Task<Void> trackEventInBackground(String name) {
        return ParseAnalytics.trackEventInBackground(name, (Map<String, String>)null);
    }

    public static Task<Void> trackEventInBackground(final String name, Map<String, String> dimensions) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("A name for the custom event must be provided.");
        }
        final Map<String, String> dimensionsCopy = dimensions != null ? Collections.unmodifiableMap(new HashMap<String, String>(dimensions)) : null;
        return ParseUser.getCurrentSessionTokenAsync().onSuccessTask((Continuation)new Continuation<String, Task<Void>>(){

            public Task<Void> then(Task<String> task) throws Exception {
                String sessionToken = (String)task.getResult();
                return ParseAnalytics.getAnalyticsController().trackEventInBackground(name, dimensionsCopy, sessionToken);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clear() {
        Map<String, Boolean> map = lruSeenPushes;
        synchronized (map) {
            lruSeenPushes.clear();
        }
    }

    static String getPushHashFromIntent(Intent intent) {
        String pushData = null;
        if (intent != null && intent.getExtras() != null) {
            pushData = intent.getExtras().getString("com.parse.Data");
        }
        if (pushData == null) {
            return null;
        }
        String pushHash = null;
        try {
            JSONObject payload = new JSONObject(pushData);
            pushHash = payload.optString("push_hash");
        }
        catch (JSONException e) {
            PLog.e(TAG, "Failed to parse push data: " + e.getMessage());
        }
        return pushHash;
    }
}

