/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.okhttp3.LogInterceptor.formatter;

import com.parkingwang.okhttp3.LogInterceptor.formatter.FastjsonFormatter;
import com.parkingwang.okhttp3.LogInterceptor.formatter.GsonFormatter;
import com.parkingwang.okhttp3.LogInterceptor.formatter.MoshiFormatter;
import com.parkingwang.okhttp3.LogInterceptor.formatter.OrgJsonFormatter;

public class JSONFormatter {
    static final JSONFormatter FORMATTER = JSONFormatter.findJSONFormatter();

    public static String formatJSON(String source) {
        try {
            return FORMATTER.format(source);
        }
        catch (Exception e) {
            return "";
        }
    }

    String format(String source) {
        return "";
    }

    private static JSONFormatter findJSONFormatter() {
        OrgJsonFormatter jsonFormatter = OrgJsonFormatter.buildIfSupported();
        if (jsonFormatter != null) {
            return jsonFormatter;
        }
        JSONFormatter gsonFormatter = GsonFormatter.buildIfSupported();
        if (gsonFormatter != null) {
            return gsonFormatter;
        }
        JSONFormatter fastjsonFormatter = FastjsonFormatter.buildIfSupported();
        if (fastjsonFormatter != null) {
            return fastjsonFormatter;
        }
        JSONFormatter moshiFormatter = MoshiFormatter.buildIfSupported();
        if (moshiFormatter != null) {
            return moshiFormatter;
        }
        return new JSONFormatter();
    }
}

