/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.keyboard.engine;

import com.parkingwang.keyboard.engine.AvailableKeyRegistry;
import com.parkingwang.keyboard.engine.BackKeyTransformer;
import com.parkingwang.keyboard.engine.Context;
import com.parkingwang.keyboard.engine.FuncKeyTransformer;
import com.parkingwang.keyboard.engine.HKMacaoKeyTransformer;
import com.parkingwang.keyboard.engine.KeyboardEntry;
import com.parkingwang.keyboard.engine.LayoutEntry;
import com.parkingwang.keyboard.engine.LayoutManager;
import com.parkingwang.keyboard.engine.LayoutMixer;
import com.parkingwang.keyboard.engine.MoreKeyTransformer;
import com.parkingwang.keyboard.engine.NeighborLayoutTransformer;
import com.parkingwang.keyboard.engine.NumberType;
import com.parkingwang.keyboard.engine.RemoveOKLayoutTransformer;
import com.parkingwang.keyboard.neighbor.NeighborManager;
import com.parkingwang.keyboard.neighbor.Province;

public class KeyboardEngine {
    private final AvailableKeyRegistry mKeyRegistry = new AvailableKeyRegistry();
    private final LayoutManager mKeyboardLayout = new LayoutManager();
    private final NeighborManager mNeighborManager = new NeighborManager();
    private final LayoutMixer mLayoutMixer = new LayoutMixer();
    private final RemoveOKLayoutTransformer mRemoveOKLayoutTransformer = new RemoveOKLayoutTransformer();
    private String mLocationProvince;

    public KeyboardEngine() {
        this.mLayoutMixer.addKeyTransformer(new FuncKeyTransformer());
        this.mLayoutMixer.addKeyTransformer(new MoreKeyTransformer());
        this.mLayoutMixer.addKeyTransformer(new BackKeyTransformer());
        this.mLayoutMixer.addKeyTransformer(new HKMacaoKeyTransformer());
        this.mLayoutMixer.addLayoutTransformer(this.mRemoveOKLayoutTransformer);
        this.mLayoutMixer.addLayoutTransformer(new NeighborLayoutTransformer());
    }

    public void setHideOKKey(boolean hide) {
        this.mRemoveOKLayoutTransformer.setRemoveEnabled(hide);
    }

    public void setLocalProvinceName(String provinceName) {
        this.mLocationProvince = provinceName;
    }

    public KeyboardEntry update(String presetNumber, int selectCharIndex, boolean showMoreLayout, NumberType fixedNumberType) {
        NumberType detectNumberType = NumberType.AUTO_DETECT.equals((Object)fixedNumberType) ? NumberType.detect(presetNumber) : fixedNumberType;
        int maxLength = detectNumberType.maxLength();
        Province province = this.mNeighborManager.getLocation(this.mLocationProvince);
        Context context = new Context(presetNumber, selectCharIndex, detectNumberType, maxLength, this.mKeyRegistry.available(detectNumberType, selectCharIndex), showMoreLayout, province);
        LayoutEntry layout2 = this.mKeyboardLayout.getLayout(context);
        LayoutEntry tr = this.mLayoutMixer.transform(context, layout2);
        LayoutEntry output = this.mLayoutMixer.mix(context, tr);
        return new KeyboardEntry(selectCharIndex, presetNumber, maxLength, output, detectNumberType);
    }
}

