/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.keyboard.engine;

import com.parkingwang.keyboard.engine.KeyType;
import com.parkingwang.keyboard.engine.Utils;

public class KeyEntry {
    public final String text;
    public final KeyType keyType;
    public final boolean isFunKey;
    public final boolean enabled;

    public KeyEntry(String text, KeyType keyType, boolean enabled) {
        this.text = text;
        this.keyType = keyType;
        this.enabled = enabled;
        this.isFunKey = !KeyType.GENERAL.equals((Object)keyType);
    }

    public static KeyEntry newOfSetEnable(KeyEntry key, boolean enabled) {
        return new KeyEntry(key.text, key.keyType, enabled);
    }

    public String toString() {
        return "KeyEntry{text='" + this.text + '\'' + ", keyType=" + (Object)((Object)this.keyType) + ", enabled=" + this.enabled + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyEntry)) {
            return false;
        }
        KeyEntry keyEntry = (KeyEntry)o;
        return Utils.equals(this.text, keyEntry.text) && this.keyType == keyEntry.keyType;
    }

    public int hashCode() {
        return Utils.hash(new Object[]{this.text, this.keyType});
    }
}

