/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.keyboard.engine;

import com.parkingwang.keyboard.engine.NumberType;
import com.parkingwang.keyboard.engine.RowEntry;
import com.parkingwang.keyboard.engine.Utils;
import java.util.HashMap;
import java.util.Map;

class AvailableKeyRegistry {
    private final Map<String, RowEntry> mCache = new HashMap<String, RowEntry>();

    AvailableKeyRegistry() {
        RowEntry lettersNumeric = Utils.mkEntitiesOf("QWERTYUPASDFGHJKLZXCVBNM0123456789");
        RowEntry civilProvince = Utils.mkEntitiesOf("\u4eac\u6d25\u664b\u5180\u8499\u8fbd\u5409\u9ed1\u6caa\u82cf\u6d59\u7696\u95fd\u8d63\u9c81\u8c6b\u9102\u6e58\u7ca4\u6842\u743c\u6e1d\u5ddd\u8d35\u4e91\u85cf\u9655\u7518\u9752\u5b81\u65b0");
        RowEntry lettersHasO = Utils.mkEntitiesOf("QWERTYUOPASDFGHJKLZXCVBNM");
        RowEntry civilPost = Utils.append(lettersNumeric, Utils.mkEntitiesOf("\u8b66\u5b66\u6e2f\u6fb3\u6302\u8bd5\u8d85\u9886"));
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.CIVIL, 0), civilProvince);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.CIVIL, 1), lettersHasO);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.CIVIL, 2), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.CIVIL, 3), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.CIVIL, 4), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.CIVIL, 5), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.CIVIL, 6), civilPost);
        RowEntry numericDF = Utils.mkEntitiesOf("0123456789DF");
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.NEW_ENERGY, 0), civilProvince);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.NEW_ENERGY, 1), lettersHasO);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.NEW_ENERGY, 2), numericDF);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.NEW_ENERGY, 3), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.NEW_ENERGY, 4), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.NEW_ENERGY, 5), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.NEW_ENERGY, 6), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.NEW_ENERGY, 7), numericDF);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.WJ2012, 0), Utils.mkEntitiesOf("W"));
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.WJ2012, 1), Utils.mkEntitiesOf("J"));
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.WJ2012, 2), civilProvince);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.WJ2012, 3), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.WJ2012, 4), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.WJ2012, 5), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.WJ2012, 6), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.WJ2012, 7), Utils.mkEntitiesOf("0123456789XBTSHJD"));
        RowEntry numeric = Utils.mkEntitiesOf("0123456789");
        RowEntry numeric123 = Utils.mkEntitiesOf("123");
        RowEntry shi = Utils.mkEntitiesOf("\u4f7f");
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.SHI2017, 0), numeric123);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.SHI2017, 1), numeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.SHI2017, 2), numeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.SHI2017, 3), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.SHI2017, 4), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.SHI2017, 5), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.SHI2017, 6), shi);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.SHI2012, 0), shi);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.SHI2012, 1), numeric123);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.SHI2012, 2), numeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.SHI2012, 3), numeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.SHI2012, 4), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.SHI2012, 5), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.SHI2012, 6), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.PLA2012, 0), Utils.mkEntitiesOf("QERTYUPASDFGHJKLZXCVBNM"));
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.PLA2012, 1), lettersHasO);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.PLA2012, 2), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.PLA2012, 3), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.PLA2012, 4), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.PLA2012, 5), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.PLA2012, 6), lettersNumeric);
        RowEntry ling = Utils.mkEntitiesOf("\u9886");
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.LING2012, 0), civilProvince);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.LING2012, 1), lettersHasO);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.LING2012, 2), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.LING2012, 3), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.LING2012, 4), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.LING2012, 5), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.LING2012, 6), ling);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.LING2018, 0), civilProvince);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.LING2018, 1), numeric123);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.LING2018, 2), numeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.LING2018, 3), numeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.LING2018, 4), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.LING2018, 5), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.LING2018, 6), ling);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.AVIATION, 0), Utils.mkEntitiesOf("\u6c11"));
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.AVIATION, 1), Utils.mkEntitiesOf("\u822a"));
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.AVIATION, 2), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.AVIATION, 3), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.AVIATION, 4), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.AVIATION, 5), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.AVIATION, 6), lettersNumeric);
        RowEntry auto = Utils.append(civilProvince, lettersNumeric, Utils.mkEntitiesOf("\u6c11\u4f7f"));
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.AUTO_DETECT, 0), auto);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.AUTO_DETECT, 1), Utils.append(lettersHasO, numeric123, Utils.mkEntitiesOf("\u822aJ")));
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.AUTO_DETECT, 2), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.AUTO_DETECT, 3), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.AUTO_DETECT, 4), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.AUTO_DETECT, 5), lettersNumeric);
        this.mCache.put(AvailableKeyRegistry.mkKey(NumberType.AUTO_DETECT, 6), civilPost);
    }

    public RowEntry available(NumberType type, int selectedIndex) {
        RowEntry found = this.mCache.get(AvailableKeyRegistry.mkKey(type, selectedIndex));
        if (null != found) {
            return found;
        }
        return new RowEntry(0);
    }

    private static String mkKey(NumberType type, int index) {
        return "@" + type.name() + "." + index;
    }
}

