/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.keyboard.engine;

import com.parkingwang.keyboard.engine.Context;
import com.parkingwang.keyboard.engine.LayoutEntry;
import com.parkingwang.keyboard.engine.NumberType;
import com.parkingwang.keyboard.engine.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class LayoutManager {
    private static final String NAME_PROVINCE = "layout.province";
    private static final String NAME_FIRST = "layout.first.spec";
    private static final String NAME_LAST = "layout.last.spec";
    private static final String NAME_WITH_IO = "layout.with.io";
    private static final String NAME_WITHOUT_IO = "layout.without.io";
    private final Map<String, LayoutEntry> mNamedLayouts = new HashMap<String, LayoutEntry>();
    private final List<LayoutProvider> mProviders = new ArrayList<LayoutProvider>(5);

    LayoutManager() {
        this.mNamedLayouts.put(NAME_PROVINCE, LayoutManager.createRows("\u4eac\u6d25\u664b\u5180\u8499\u8fbd\u5409\u9ed1\u6caa", "\u82cf\u6d59\u7696\u95fd\u8d63\u9c81\u8c6b\u9102\u6e58", "\u7ca4\u6842\u743c\u6e1d\u5ddd\u8d35\u4e91\u85cf\u9655", "\u7518\u9752\u5b81\u65b0>-+"));
        this.mNamedLayouts.put(NAME_FIRST, LayoutManager.createRows("123456789", "QWEYCVBN0", "ASDFGHJKL", "ZX\u6c11\u4f7f<-+"));
        this.mNamedLayouts.put(NAME_WITH_IO, LayoutManager.createRows("1234567890", "QWERTYUIOP", "ASDFGHJKLM", "ZXCVBN-+"));
        this.mNamedLayouts.put(NAME_LAST, LayoutManager.createRows("\u5b66\u8b66\u6e2f\u6fb3\u822a\u6302\u8bd5\u8d85\u4f7f\u9886", "1234567890", "ABCDEFGHJK", "WXYZ<-+"));
        this.mNamedLayouts.put(NAME_WITHOUT_IO, LayoutManager.createRows("1234567890", "QWERTYUPMN", "ASDFGHJKLB", "ZXCV>-+"));
        this.mProviders.add(new ProvinceLayoutProvider());
        this.mProviders.add(new FirstSpecLayoutProvider());
        this.mProviders.add(new WithIOLayoutProvider());
        this.mProviders.add(new LastSpecLayoutProvider());
        this.mProviders.add(new WithoutIOLayoutProvider());
    }

    private static LayoutEntry createRows(String ... rows) {
        LayoutEntry layout2 = new LayoutEntry(rows.length);
        for (String keys : rows) {
            layout2.add(Utils.mkEntitiesOf(keys));
        }
        return layout2;
    }

    public LayoutEntry getLayout(Context ctx) {
        LayoutProvider provider;
        LayoutEntry layout2 = null;
        Iterator<LayoutProvider> iterator = this.mProviders.iterator();
        while (iterator.hasNext() && null == (layout2 = (provider = iterator.next()).get(ctx))) {
        }
        return layout2;
    }

    final class WithoutIOLayoutProvider
    implements LayoutProvider {
        WithoutIOLayoutProvider() {
        }

        @Override
        public LayoutEntry get(Context ctx) {
            if (6 == ctx.selectIndex) {
                if (NumberType.CIVIL.equals((Object)ctx.numberType) && !ctx.reqSpecLayout) {
                    return (LayoutEntry)LayoutManager.this.mNamedLayouts.get(LayoutManager.NAME_WITHOUT_IO);
                }
                if (ctx.numberType.isAnyOf(NumberType.NEW_ENERGY, NumberType.WJ2012, NumberType.PLA2012, NumberType.SHI2012, NumberType.AVIATION)) {
                    return (LayoutEntry)LayoutManager.this.mNamedLayouts.get(LayoutManager.NAME_WITHOUT_IO);
                }
                return null;
            }
            if (7 == ctx.selectIndex) {
                return (LayoutEntry)LayoutManager.this.mNamedLayouts.get(LayoutManager.NAME_WITHOUT_IO);
            }
            return null;
        }
    }

    final class LastSpecLayoutProvider
    implements LayoutProvider {
        LastSpecLayoutProvider() {
        }

        @Override
        public LayoutEntry get(Context ctx) {
            if (1 == ctx.selectIndex) {
                return (LayoutEntry)LayoutManager.this.mNamedLayouts.get(LayoutManager.NAME_LAST);
            }
            if (6 == ctx.selectIndex) {
                if (ctx.numberType.isAnyOf(NumberType.HK_MACAO, NumberType.SHI2017, NumberType.LING2012, NumberType.LING2018)) {
                    return (LayoutEntry)LayoutManager.this.mNamedLayouts.get(LayoutManager.NAME_LAST);
                }
                if (ctx.reqSpecLayout) {
                    return (LayoutEntry)LayoutManager.this.mNamedLayouts.get(LayoutManager.NAME_LAST);
                }
                return null;
            }
            return null;
        }
    }

    final class WithIOLayoutProvider
    implements LayoutProvider {
        WithIOLayoutProvider() {
        }

        @Override
        public LayoutEntry get(Context ctx) {
            if (3 == ctx.selectIndex || 4 == ctx.selectIndex || 5 == ctx.selectIndex) {
                return (LayoutEntry)LayoutManager.this.mNamedLayouts.get(LayoutManager.NAME_WITH_IO);
            }
            if (1 == ctx.selectIndex && !NumberType.AVIATION.equals((Object)ctx.numberType)) {
                return (LayoutEntry)LayoutManager.this.mNamedLayouts.get(LayoutManager.NAME_WITH_IO);
            }
            if (2 == ctx.selectIndex && !NumberType.WJ2012.equals((Object)ctx.numberType)) {
                return (LayoutEntry)LayoutManager.this.mNamedLayouts.get(LayoutManager.NAME_WITH_IO);
            }
            return null;
        }
    }

    final class FirstSpecLayoutProvider
    implements LayoutProvider {
        FirstSpecLayoutProvider() {
        }

        @Override
        public LayoutEntry get(Context ctx) {
            if (0 == ctx.selectIndex) {
                if (ctx.numberType.isAnyOf(NumberType.WJ2012, NumberType.PLA2012, NumberType.SHI2012, NumberType.SHI2017, NumberType.AVIATION)) {
                    return (LayoutEntry)LayoutManager.this.mNamedLayouts.get(LayoutManager.NAME_FIRST);
                }
                if (ctx.reqSpecLayout) {
                    return (LayoutEntry)LayoutManager.this.mNamedLayouts.get(LayoutManager.NAME_FIRST);
                }
                return null;
            }
            return null;
        }
    }

    final class ProvinceLayoutProvider
    implements LayoutProvider {
        ProvinceLayoutProvider() {
        }

        @Override
        public LayoutEntry get(Context ctx) {
            if (0 == ctx.selectIndex || 2 == ctx.selectIndex) {
                if (0 == ctx.selectIndex && NumberType.AUTO_DETECT.equals((Object)ctx.numberType) && !ctx.reqSpecLayout) {
                    return (LayoutEntry)LayoutManager.this.mNamedLayouts.get(LayoutManager.NAME_PROVINCE);
                }
                if (0 == ctx.selectIndex && ctx.numberType.isAnyOf(NumberType.CIVIL, NumberType.NEW_ENERGY, NumberType.HK_MACAO, NumberType.LING2012, NumberType.LING2018)) {
                    return (LayoutEntry)LayoutManager.this.mNamedLayouts.get(LayoutManager.NAME_PROVINCE);
                }
                if (2 == ctx.selectIndex && NumberType.WJ2012.equals((Object)ctx.numberType)) {
                    return (LayoutEntry)LayoutManager.this.mNamedLayouts.get(LayoutManager.NAME_PROVINCE);
                }
                return null;
            }
            return null;
        }
    }

    static interface LayoutProvider {
        public LayoutEntry get(Context var1);
    }
}

