/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.vehiclekeyboard.view;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.parkingwang.vehiclekeyboard.view.KeyRowLayout;
import com.parkingwang.vehiclekeyboard.view.KeyView;
import com.parkingwang.vehiclekeyboard.view.KeyboardView;
import java.util.Stack;

class KeyViewCacheHelper {
    private final Stack<KeyView> mKeyViews = new Stack();

    KeyViewCacheHelper() {
    }

    void recyclerKeyRows(KeyboardView keyboardView, int row) {
        block3: {
            int childCount;
            block2: {
                childCount = keyboardView.getChildCount();
                if (childCount <= row) break block2;
                int trimCount = childCount - row;
                for (int i = 0; i < trimCount; ++i) {
                    this.trimKeyRowLayout(keyboardView, 0);
                }
                break block3;
            }
            if (childCount >= row) break block3;
            for (int i = childCount; i < row; ++i) {
                this.fixKeyRowLayout(keyboardView);
            }
        }
    }

    private void trimKeyRowLayout(KeyboardView keyboardView, int row) {
        KeyRowLayout keyRow = (KeyRowLayout)keyboardView.getChildAt(row);
        int column = keyRow.getChildCount();
        boolean targetIndex = false;
        for (int j = 0; j < column; ++j) {
            this.pushKeyView((KeyView)keyRow.getChildAt(0));
            keyRow.removeViewAt(0);
        }
        keyboardView.removeView((View)keyRow);
    }

    private void fixKeyRowLayout(KeyboardView keyboardView) {
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        KeyRowLayout keyRowLayout = new KeyRowLayout(keyboardView.getContext());
        keyRowLayout.setLayoutParams((ViewGroup.LayoutParams)params);
        keyboardView.addView((View)keyRowLayout, 0);
    }

    void recyclerKeyViewsInRow(KeyRowLayout keyRow, int targetCount, View.OnClickListener listener) {
        int childCount = keyRow.getChildCount();
        if (childCount < targetCount) {
            for (int i = childCount; i < targetCount; ++i) {
                keyRow.addView((View)this.pullKeyView(keyRow.getContext(), listener));
            }
        } else if (childCount > targetCount) {
            this.trimKeyViews(keyRow, targetCount, childCount);
        }
    }

    private void trimKeyViews(KeyRowLayout keyRow, int targetCount, int childCount) {
        int targetIndex = targetCount;
        for (int i = targetCount; i < childCount; ++i) {
            KeyView keyView = (KeyView)keyRow.getChildAt(targetIndex);
            keyRow.removeViewAt(targetIndex);
            this.pushKeyView(keyView);
        }
    }

    private KeyView pullKeyView(Context context, View.OnClickListener listener) {
        if (this.mKeyViews.empty()) {
            KeyView keyView = new KeyView(context);
            keyView.setOnClickListener(listener);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(0, -1);
            keyView.setLayoutParams((ViewGroup.LayoutParams)params);
            return keyView;
        }
        return this.mKeyViews.pop();
    }

    private void pushKeyView(KeyView keyView) {
        this.mKeyViews.push(keyView);
    }
}

