/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.vehiclekeyboard.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.widget.LinearLayout;
import com.parkingwang.vehiclekeyboard.R;
import com.parkingwang.vehiclekeyboard.core.KeyEntry;
import com.parkingwang.vehiclekeyboard.core.KeyType;
import com.parkingwang.vehiclekeyboard.core.KeyboardEngine;
import com.parkingwang.vehiclekeyboard.core.KeyboardEntry;
import com.parkingwang.vehiclekeyboard.core.NumberType;
import com.parkingwang.vehiclekeyboard.support.Texts;
import com.parkingwang.vehiclekeyboard.view.KeyRowLayout;
import com.parkingwang.vehiclekeyboard.view.KeyView;
import com.parkingwang.vehiclekeyboard.view.KeyViewCacheHelper;
import com.parkingwang.vehiclekeyboard.view.OnKeyboardChangedListener;
import hugo.weaving.DebugLog;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class KeyboardView
extends LinearLayout {
    private static final String TAG = "KeyboardView";
    private final Paint mDividerPaint = new Paint(5);
    private int mRowSpace;
    private int mDefaultKeyHeight;
    private boolean mShowBubble = true;
    private float mCNTextSize;
    private float mENTextSize;
    private MotionEvent mLastEvent;
    private final List<OnKeyboardChangedListener> mKeyboardChangedListeners = new CopyOnWriteArrayList<OnKeyboardChangedListener>();
    private final KeyboardEngine mKeyboardEngine = new KeyboardEngine();
    private final KeyViewCacheHelper mKeyCacheHelper = new KeyViewCacheHelper();
    private final View.OnClickListener mOnKeyPressedListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (!(v instanceof KeyView)) {
                return;
            }
            KeyEntry key = ((KeyView)v).getBoundKey();
            KeyboardView.this.onKeyPressed(key);
        }
    };
    private String mStashedNumber;
    private int mStashedIndex;
    private NumberType mStashedNumberType;

    public KeyboardView(Context context) {
        this(context, null);
    }

    public KeyboardView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        Resources resources = this.getResources();
        this.mDefaultKeyHeight = resources.getDimensionPixelSize(R.dimen.pwk_keyboard_key_height);
        this.setOrientation(1);
        Drawable rowDivider = ContextCompat.getDrawable((Context)context, (int)R.drawable.pwk_space_vertical);
        this.mRowSpace = rowDivider.getIntrinsicHeight();
        this.setDividerDrawable(rowDivider);
        this.setShowDividers(2);
        this.setBackgroundResource(R.color.pwk_keyboard_background);
        int dividerColor = ContextCompat.getColor((Context)context, (int)R.color.pwk_keyboard_divider);
        this.mDividerPaint.setColor(dividerColor);
        int leftPadding = this.getResources().getDimensionPixelSize(R.dimen.pwk_keyboard_padding_left);
        int topPadding = this.getResources().getDimensionPixelSize(R.dimen.pwk_keyboard_padding_top);
        int rightPadding = this.getResources().getDimensionPixelSize(R.dimen.pwk_keyboard_padding_right);
        int bottomPadding = this.getResources().getDimensionPixelSize(R.dimen.pwk_keyboard_padding_bottom);
        this.setPadding(leftPadding, topPadding, rightPadding, bottomPadding);
        this.setClipChildren(false);
        this.setClipToPadding(false);
        this.mCNTextSize = this.getResources().getDimensionPixelSize(R.dimen.pwk_keyboard_key_cn_text_size);
        this.mENTextSize = this.getResources().getDimensionPixelSize(R.dimen.pwk_keyboard_key_en_text_size);
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
            }
        });
    }

    public final void update(@NonNull String number) {
        this.update(number, number.length(), NumberType.AUTO_DETECT);
    }

    public final void update(@NonNull String number, int index) {
        this.update(number, index, NumberType.AUTO_DETECT);
    }

    @DebugLog
    public void update(@NonNull String number, int showIndex, NumberType fixedNumberType) {
        this.mStashedNumber = number;
        this.mStashedNumberType = fixedNumberType;
        if (showIndex != 200 && showIndex != 100) {
            this.mStashedIndex = showIndex;
        }
        KeyboardEntry keyboard = this.mKeyboardEngine.update(number, showIndex, fixedNumberType);
        this.renderLayout(keyboard);
        try {
            for (OnKeyboardChangedListener listener : this.mKeyboardChangedListeners) {
                listener.onKeyboardChanged(keyboard);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"On keyboard changed", (Throwable)e);
        }
    }

    private void onKeyPressed(KeyEntry key) {
        switch (key.keyType) {
            case FUNC_OK: {
                for (OnKeyboardChangedListener l : this.mKeyboardChangedListeners) {
                    l.onConfirmKey();
                }
                break;
            }
            case FUNC_DELETE: {
                for (OnKeyboardChangedListener l : this.mKeyboardChangedListeners) {
                    l.onDeleteKey();
                }
                break;
            }
            default: {
                for (OnKeyboardChangedListener l : this.mKeyboardChangedListeners) {
                    l.onTextKey(key.text);
                }
                break;
            }
            case FUNC_MORE: {
                if (0 == this.mStashedIndex) {
                    this.update(this.mStashedNumber, 100, this.mStashedNumberType);
                    break;
                }
                this.update(this.mStashedNumber, 200, this.mStashedNumberType);
                break;
            }
            case FUNC_BACK: {
                this.update(this.mStashedNumber, this.mStashedIndex, this.mStashedNumberType);
            }
        }
    }

    public void addKeyboardChangedListener(@NonNull OnKeyboardChangedListener callback) {
        this.mKeyboardChangedListeners.add(callback);
    }

    public void removeKeyboardChangedListener(@NonNull OnKeyboardChangedListener callback) {
        this.mKeyboardChangedListeners.remove(callback);
    }

    public void setShowBubble(boolean showBubble) {
        this.mShowBubble = showBubble;
    }

    public void setCNTextSize(float textSize) {
        this.setCNTextSize(2, textSize);
    }

    public void setCNTextSize(int unit, float textSize) {
        this.mCNTextSize = TypedValue.applyDimension((int)unit, (float)textSize, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public void setENTextSize(float textSize) {
        this.setENTextSize(2, textSize);
    }

    public void setENTextSize(int unit, float textSize) {
        this.mENTextSize = TypedValue.applyDimension((int)unit, (float)textSize, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    @DebugLog
    private void renderLayout(KeyboardEntry keyboard) {
        List<List<KeyEntry>> keyRows = keyboard.keyRows;
        int maxColumn = keyRows.get(0).size();
        int rowSize = keyRows.size();
        this.mKeyCacheHelper.recyclerKeyRows(this, rowSize);
        for (int rowIndex = 0; rowIndex < rowSize; ++rowIndex) {
            List<KeyEntry> keyEntryRow = keyRows.get(rowIndex);
            KeyRowLayout rowLayout = (KeyRowLayout)this.getChildAt(rowIndex);
            rowLayout.setMaxColumn(maxColumn);
            int columnSize = keyEntryRow.size();
            int funKeyCount = 0;
            for (KeyEntry keyEntry : keyEntryRow) {
                if (!keyEntry.isFunKey) continue;
                ++funKeyCount;
            }
            rowLayout.setFunKeyCount(funKeyCount);
            this.mKeyCacheHelper.recyclerKeyViewsInRow(rowLayout, columnSize, this.mOnKeyPressedListener);
            int size = keyEntryRow.size();
            for (int i = 0; i < size; ++i) {
                KeyEntry key = keyEntryRow.get(i);
                KeyView keyView = (KeyView)rowLayout.getChildAt(i);
                keyView.bindKey(key);
                if (key.keyType == KeyType.FUNC_DELETE) {
                    keyView.setText("");
                } else {
                    keyView.setText(key.text);
                }
                if (Texts.isEnglishLetterOrDigit(key.text)) {
                    keyView.setTextSize(0, this.mENTextSize);
                } else {
                    keyView.setTextSize(0, this.mCNTextSize);
                }
                keyView.setShowBubble(this.mShowBubble);
                keyView.setEnabled(key.enabled);
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int rows = this.getChildCount();
        if (heightMode == Integer.MIN_VALUE) {
            height = rows * this.mDefaultKeyHeight + (rows - 1) * this.mRowSpace + this.getPaddingTop() + this.getPaddingBottom();
            for (int i = 0; i < rows; ++i) {
                this.getChildAt((int)i).getLayoutParams().height = this.mDefaultKeyHeight;
            }
        } else if (heightMode == 0x40000000 && rows > 0) {
            int childHeight = (height - this.getPaddingTop() - this.getPaddingBottom() - (rows - 1) * this.mRowSpace) / rows;
            for (int i = 0; i < rows; ++i) {
                this.getChildAt((int)i).getLayoutParams().height = childHeight;
            }
        }
        super.onMeasure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), 2.0f, this.mDividerPaint);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (ev.getPointerCount() > 1 && ev.getActionMasked() == 5) {
            float x = ev.getX(ev.getActionIndex());
            float y = ev.getY(ev.getActionIndex());
            if (this.mLastEvent != null && x >= 0.0f && x < (float)this.getWidth() && y >= 0.0f && y <= (float)this.getHeight()) {
                MotionEvent cancelEvent = MotionEvent.obtain((long)this.mLastEvent.getDownTime(), (long)this.mLastEvent.getEventTime(), (int)1, (float)this.mLastEvent.getX(), (float)this.mLastEvent.getY(), (int)this.mLastEvent.getMetaState());
                super.dispatchTouchEvent(cancelEvent);
                if (cancelEvent != null) {
                    cancelEvent.recycle();
                }
                return true;
            }
        }
        this.mLastEvent = ev;
        return super.dispatchTouchEvent(ev);
    }
}

