/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.vehiclekeyboard.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import com.annimon.stream.Collectors;
import com.annimon.stream.Optional;
import com.annimon.stream.Stream;
import com.annimon.stream.function.BiFunction;
import com.annimon.stream.function.Consumer;
import com.annimon.stream.function.Function;
import com.annimon.stream.function.Predicate;
import com.parkingwang.vehiclekeyboard.R;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class InputView
extends LinearLayout {
    private static final String KEY_INIT_NUMBER = "pwk.keyboard.key:init.number";
    private Button mButtonKeyOf6;
    private Button mButtonEndOf6;
    private final Button[] mFieldViews = new Button[8];
    private final HashMap<String, Object> mKeyMap = new HashMap();
    private final Set<OnFieldViewSelectedListener> mOnFieldViewSelectedListeners = new HashSet<OnFieldViewSelectedListener>(4);
    private final View.OnClickListener mOnFieldViewClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            ClickMetas clickMetas = InputView.this.getClickedMeta((Button)v);
            if (clickMetas.clickIndex <= clickMetas.numberLength) {
                if (clickMetas.clickIndex != clickMetas.selectedIndex) {
                    if (clickMetas.selectedIndex >= 0) {
                        InputView.this.clearSelectedState(InputView.this.mFieldViews[clickMetas.selectedIndex]);
                    }
                    InputView.this.setFieldSelected(InputView.this.mFieldViews[clickMetas.clickIndex]);
                }
                for (OnFieldViewSelectedListener listener : InputView.this.mOnFieldViewSelectedListeners) {
                    listener.onSelectedAt(clickMetas.clickIndex);
                }
            }
        }
    };

    public InputView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public InputView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        boolean textSizeDefined;
        InputView.inflate((Context)context, (int)R.layout.pwk_input_view, (ViewGroup)this);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.InputView);
        float textSize = ta.getDimension(R.styleable.InputView_pwkInputTextSize, 0.0f);
        ta.recycle();
        int[] resIds = new int[]{R.id.number_0, R.id.number_1, R.id.number_2, R.id.number_3, R.id.number_4, R.id.number_5, R.id.number_6, R.id.number_7};
        this.mButtonKeyOf6 = (Button)this.findViewById(R.id.number_6);
        this.mButtonEndOf6 = (Button)this.findViewById(R.id.number_6_as_end);
        this.mButtonEndOf6.setOnClickListener(this.mOnFieldViewClickListener);
        boolean bl = textSizeDefined = textSize > 0.0f;
        if (textSizeDefined) {
            this.mButtonEndOf6.setTextSize(0, textSize);
        }
        for (int i = 0; i < this.mFieldViews.length; ++i) {
            this.mFieldViews[i] = (Button)this.findViewById(resIds[i]);
            this.mFieldViews[i].setOnClickListener(this.mOnFieldViewClickListener);
            if (!textSizeDefined) continue;
            this.mFieldViews[i].setTextSize(0, textSize);
        }
        this.set8thFieldViewVisibility(false, true);
    }

    public void updateSelectedCharAndSelectNext(final String text) {
        this.withFields().filter((Predicate)new Predicate<Button>(){

            public boolean test(Button view) {
                return view.isSelected();
            }
        }).findSingle().ifPresent((Consumer)new Consumer<Button>(){

            public void accept(Button button) {
                button.setText((CharSequence)text);
                InputView.this.performNextFieldViewBy(button);
            }
        });
    }

    public void removeLastCharOfNumber() {
        this.findLastFilledTextFieldView().ifPresent((Consumer)new Consumer<Button>(){

            public void accept(Button current) {
                current.setText(null);
                InputView.this.performFieldViewSetToSelected(current);
            }
        });
    }

    public boolean isCompleted() {
        return this.withFields().allMatch(this.checkIfNotEmpty());
    }

    public boolean isNumberChanged() {
        String current = this.getNumber();
        return !current.equals(String.valueOf(this.mKeyMap.get(KEY_INIT_NUMBER)));
    }

    public void updateNumber(String number) {
        this.mKeyMap.put(KEY_INIT_NUMBER, number);
        char[] chars = number.toCharArray();
        boolean charsOf8 = chars.length >= 8;
        this.set8thFieldViewVisibility(charsOf8, !charsOf8);
        this.mButtonEndOf6.setText(null);
        this.mButtonKeyOf6.setText(null);
        for (int i = 0; i < this.mFieldViews.length; ++i) {
            String text = i < chars.length ? String.valueOf(chars[i]) : null;
            this.mFieldViews[i].setText((CharSequence)text);
        }
    }

    public String getNumber() {
        return (String)this.withFields().map((Function)new Function<Button, String>(){

            public String apply(Button textView) {
                return textView.getText().toString();
            }
        }).reduce((Object)"", (BiFunction)new BiFunction<String, String, String>(){

            public String apply(String char1, String char2) {
                return char1 + char2;
            }
        });
    }

    public void performFirstFieldView() {
        this.performFieldViewSetToSelected(this.mFieldViews[0]);
    }

    public void performLastFieldView() {
        this.findLastFilledTextFieldView().ifPresentOrElse((Consumer)new Consumer<Button>(){

            public void accept(Button button) {
                InputView.this.performNextFieldViewBy(button);
            }
        }, new Runnable(){

            @Override
            public void run() {
                InputView.this.performFieldViewSetToSelected(InputView.this.mFieldViews[0]);
            }
        });
    }

    public void performNextFieldView() {
        ClickMetas clickMetas = this.getClickedMeta(null);
        if (clickMetas.selectedIndex >= 0) {
            this.performNextFieldViewBy(this.mFieldViews[clickMetas.selectedIndex]);
        }
    }

    public void performCurrentFieldView() {
        ClickMetas clickMetas = this.getClickedMeta(null);
        if (clickMetas.selectedIndex >= 0) {
            this.performFieldViewSetToSelected(this.mFieldViews[clickMetas.selectedIndex]);
        }
    }

    public void set8thFieldViewVisibility(boolean toShow, boolean clearText) {
        Button button8th = this.mFieldViews[7];
        boolean isShown = button8th.isShown();
        if (toShow) {
            if (!isShown) {
                button8th.setVisibility(0);
            }
            this.mButtonEndOf6.setVisibility(8);
            this.mButtonKeyOf6.setVisibility(0);
            this.mFieldViews[6] = this.mButtonKeyOf6;
        } else {
            if (isShown) {
                button8th.setVisibility(8);
            }
            this.mButtonEndOf6.setVisibility(0);
            this.mButtonKeyOf6.setVisibility(8);
            this.mFieldViews[6] = this.mButtonEndOf6;
        }
        if (clearText && !InputView.isButtonEmpty(button8th)) {
            button8th.setText(null);
        }
    }

    public boolean isLastFieldViewSelected() {
        if (this.mFieldViews[7].isShown()) {
            return this.mFieldViews[7].isSelected();
        }
        return this.mFieldViews[6].isSelected();
    }

    public InputView addOnFieldViewSelectedListener(OnFieldViewSelectedListener listener) {
        this.mOnFieldViewSelectedListeners.add(listener);
        return this;
    }

    private void performFieldViewSetToSelected(Button target) {
        this.mOnFieldViewClickListener.onClick((View)target);
        this.setFieldSelected(target);
    }

    private void performNextFieldViewBy(Button current) {
        List buttons = (List)this.withFields().collect(Collectors.toList());
        int nextIndex = buttons.lastIndexOf(current) + 1;
        int clickIndex = Math.min(nextIndex, buttons.size() - 1);
        this.performFieldViewSetToSelected((Button)buttons.get(clickIndex));
    }

    private Optional<Button> findLastFilledTextFieldView() {
        ArrayList<Button> reverse = new ArrayList<Button>(Arrays.asList(this.mFieldViews));
        Collections.reverse(reverse);
        return Stream.of(reverse).filter(this.checkIfShown()).filter(this.checkIfNotEmpty()).findFirst();
    }

    private void clearSelectedState(Button target) {
        target.setSelected(false);
    }

    private void setFieldSelected(Button target) {
        for (Button btn : this.mFieldViews) {
            btn.setSelected(btn == target);
        }
    }

    private Stream<Button> withFields() {
        return Stream.of((Object[])this.mFieldViews).filter(this.checkIfShown());
    }

    private Predicate<Button> checkIfShown() {
        return new Predicate<Button>(){

            public boolean test(Button value) {
                return value.isShown();
            }
        };
    }

    private Predicate<Button> checkIfNotEmpty() {
        return new Predicate<Button>(){

            public boolean test(Button button) {
                return !InputView.isButtonEmpty(button);
            }
        };
    }

    private ClickMetas getClickedMeta(Button clicked) {
        short selected = -1;
        short current = 0;
        short length = 0;
        for (int i = 0; i < this.mFieldViews.length; ++i) {
            Button item = this.mFieldViews[i];
            if (item == clicked) {
                current = (short)i;
            }
            if (item.isSelected()) {
                selected = (short)i;
            }
            if (InputView.isButtonEmpty(item)) continue;
            length = (short)(length + 1);
        }
        return new ClickMetas(selected, current, length);
    }

    private static boolean isButtonEmpty(Button button) {
        return button.getText().length() == 0;
    }

    public static interface OnFieldViewSelectedListener {
        public void onSelectedAt(int var1);
    }

    private static class ClickMetas {
        final short selectedIndex;
        final short clickIndex;
        final short numberLength;

        private ClickMetas(short selectedIndex, short clickIndex, short numberLength) {
            this.selectedIndex = selectedIndex;
            this.clickIndex = clickIndex;
            this.numberLength = numberLength;
        }
    }
}

