/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.vehiclekeyboard;

import com.annimon.stream.Collectors;
import com.annimon.stream.Stream;
import com.annimon.stream.function.Function;
import com.annimon.stream.function.Predicate;
import com.parkingwang.vehiclekeyboard.core.KeyEntry;
import com.parkingwang.vehiclekeyboard.core.KeyboardEntry;
import com.parkingwang.vehiclekeyboard.view.InputView;
import com.parkingwang.vehiclekeyboard.view.OnKeyboardChangedListener;
import java.util.List;

class AutoCommit
extends OnKeyboardChangedListener.Simple {
    private final InputView mInputView;
    private boolean mIsDeleteAction = false;

    public AutoCommit(InputView inputView) {
        this.mInputView = inputView;
    }

    @Override
    public void onTextKey(String text) {
        this.mIsDeleteAction = false;
    }

    @Override
    public void onDeleteKey() {
        this.mIsDeleteAction = true;
    }

    @Override
    public void onKeyboardChanged(KeyboardEntry keyboard) {
        if (6 != keyboard.selectedPosition) {
            return;
        }
        if (this.mIsDeleteAction) {
            return;
        }
        KeyEntry key = this.singleKey(keyboard);
        if (key != null) {
            this.mIsDeleteAction = false;
            this.mInputView.updateSelectedCharAndSelectNext(key.text);
        }
    }

    private KeyEntry singleKey(KeyboardEntry keyboard) {
        List keys = (List)Stream.of((Iterable)keyboard.keyRows).flatMap((Function)new Function<List<KeyEntry>, Stream<KeyEntry>>(){

            public Stream<KeyEntry> apply(List<KeyEntry> keyEntries) {
                return Stream.of(keyEntries);
            }
        }).filter((Predicate)new Predicate<KeyEntry>(){

            public boolean test(KeyEntry key) {
                return !key.isFunKey && key.enabled;
            }
        }).collect(Collectors.toList());
        if (1 == keys.size()) {
            return (KeyEntry)keys.get(0);
        }
        return null;
    }
}

