/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.vehiclekeyboard.core;

import com.parkingwang.vehiclekeyboard.core.Env;
import com.parkingwang.vehiclekeyboard.core.GeneralKeyMapper;
import com.parkingwang.vehiclekeyboard.core.KeyEntry;
import com.parkingwang.vehiclekeyboard.core.KeyboardEntry;
import com.parkingwang.vehiclekeyboard.core.LayoutRegistry;
import com.parkingwang.vehiclekeyboard.core.Mixer;
import com.parkingwang.vehiclekeyboard.core.NumberType;
import com.parkingwang.vehiclekeyboard.core.PrepareKeyRegistry;
import java.util.List;

public class KeyboardEngine {
    public static final int INDEX_PREFIX = 100;
    public static final int INDEX_POSTFIX = 200;
    private static final String TAG = "KeyboardEngine";
    private final PrepareKeyRegistry mPrepareKeyRegistry = new PrepareKeyRegistry();
    private final LayoutRegistry mLayoutRegistry = new LayoutRegistry();
    private final Mixer mMixer = new Mixer();

    public KeyboardEngine() {
        this.mMixer.addMapper(new GeneralKeyMapper());
    }

    public KeyboardEntry update(String presetNumber, int selectCharIndex, NumberType fixedNumberType) {
        NumberType detectNumberType = NumberType.AUTO_DETECT.equals((Object)fixedNumberType) ? NumberType.detect(presetNumber) : fixedNumberType;
        int maxLength = detectNumberType.maxLength();
        Env env = new Env(presetNumber, selectCharIndex, detectNumberType, maxLength, this.mPrepareKeyRegistry.available(detectNumberType, selectCharIndex));
        List<List<KeyEntry>> layout2 = this.mLayoutRegistry.layout(env, selectCharIndex);
        List<List<KeyEntry>> output = this.mMixer.mix(env, layout2);
        return new KeyboardEntry(selectCharIndex, presetNumber, maxLength, output, detectNumberType);
    }
}

