/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.vehiclekeyboard.support;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import com.parkingwang.vehiclekeyboard.R;
import com.parkingwang.vehiclekeyboard.view.KeyboardView;

public class PopupHelper {
    public static boolean showToActivity(Activity activity, KeyboardView keyboardView) {
        View decorView = activity.getWindow().getDecorView();
        FrameLayout keyboardWrapper = (FrameLayout)decorView.findViewById(R.id.keyboard_wrapper_id);
        if (keyboardWrapper == null) {
            ViewParent keyboardViewParent = keyboardView.getParent();
            if (keyboardViewParent != null && ((View)keyboardViewParent).getId() == R.id.keyboard_wrapper_id && keyboardViewParent instanceof FrameLayout) {
                keyboardWrapper = (FrameLayout)keyboardViewParent;
                PopupHelper.makeSureHasNoParent((View)keyboardWrapper);
            }
            if (keyboardWrapper == null) {
                keyboardWrapper = PopupHelper.wrapKeyboardView(activity, keyboardView);
            }
            PopupHelper.insetKeyboardView(decorView, keyboardWrapper);
            if (decorView instanceof FrameLayout) {
                FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
                params.gravity = 80;
                ((ViewGroup)decorView).addView((View)keyboardWrapper, (ViewGroup.LayoutParams)params);
            }
            return true;
        }
        keyboardWrapper.setVisibility(0);
        keyboardWrapper.bringToFront();
        return false;
    }

    @NonNull
    private static FrameLayout wrapKeyboardView(Activity activity, KeyboardView keyboardView) {
        FrameLayout keyboardWrapper = new FrameLayout((Context)activity);
        keyboardWrapper.setId(R.id.keyboard_wrapper_id);
        keyboardWrapper.setClipChildren(false);
        FrameLayout.LayoutParams keyboardParams = new FrameLayout.LayoutParams(-1, -2, 80);
        keyboardWrapper.addView((View)keyboardView, (ViewGroup.LayoutParams)keyboardParams);
        return keyboardWrapper;
    }

    private static void insetKeyboardView(View decorView, FrameLayout keyboardWrapper) {
        Rect rect = new Rect();
        decorView.getWindowVisibleDisplayFrame(rect);
        int paddingBottom = decorView.getHeight() - rect.bottom;
        keyboardWrapper.setPadding(0, 0, 0, paddingBottom);
    }

    private static void makeSureHasNoParent(View view) {
        if (view.getParent() != null) {
            ((ViewGroup)view.getParent()).removeView(view);
        }
    }

    public static boolean dismissFromActivity(Activity activity) {
        View view = activity.getWindow().getDecorView().findViewById(R.id.keyboard_wrapper_id);
        if (view == null) {
            return false;
        }
        ((ViewGroup)view.getParent()).removeView(view);
        return true;
    }
}

