/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.vehiclekeyboard.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import com.annimon.stream.Collectors;
import com.annimon.stream.Optional;
import com.annimon.stream.Stream;
import com.annimon.stream.function.BiFunction;
import com.annimon.stream.function.Consumer;
import com.annimon.stream.function.Function;
import com.annimon.stream.function.Predicate;
import com.parkingwang.vehiclekeyboard.R;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class InputView
extends LinearLayout {
    private static final String KEY_INIT_NUMBER = "pwk.keyboard.key:init.number";
    private Button mButtonKeyOf6;
    private Button mButtonEndOf6;
    private final Button[] mButtonItems = new Button[8];
    private final HashMap<String, Object> mKeyMap = new HashMap();
    private final Set<OnItemSelectedListener> mOnItemSelectedListeners = new HashSet<OnItemSelectedListener>(4);
    private final View.OnClickListener mOnButtonItemClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            Meta meta = InputView.this.getClickedMeta((Button)v);
            if (meta.clickIndex <= meta.numberLength) {
                if (meta.clickIndex != meta.selectedIndex) {
                    if (meta.selectedIndex >= 0) {
                        InputView.this.clearSelectedState(InputView.this.mButtonItems[meta.selectedIndex]);
                    }
                    InputView.this.setSelectedState(InputView.this.mButtonItems[meta.clickIndex]);
                }
                for (OnItemSelectedListener listener : InputView.this.mOnItemSelectedListeners) {
                    listener.onSelected(meta.clickIndex);
                }
            }
        }
    };

    public InputView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public InputView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        boolean textSizeDefined;
        InputView.inflate((Context)context, (int)R.layout.pwk_input_view, (ViewGroup)this);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.InputView);
        float textSize = ta.getDimension(R.styleable.InputView_pwkInputTextSize, 0.0f);
        ta.recycle();
        int[] resIds = new int[]{R.id.number_0, R.id.number_1, R.id.number_2, R.id.number_3, R.id.number_4, R.id.number_5, R.id.number_6, R.id.number_7};
        this.mButtonKeyOf6 = (Button)this.findViewById(R.id.number_6);
        this.mButtonEndOf6 = (Button)this.findViewById(R.id.number_6_as_end);
        this.mButtonEndOf6.setOnClickListener(this.mOnButtonItemClickListener);
        boolean bl = textSizeDefined = textSize > 0.0f;
        if (textSizeDefined) {
            this.mButtonEndOf6.setTextSize(0, textSize);
        }
        for (int i = 0; i < this.mButtonItems.length; ++i) {
            this.mButtonItems[i] = (Button)this.findViewById(resIds[i]);
            this.mButtonItems[i].setOnClickListener(this.mOnButtonItemClickListener);
            if (!textSizeDefined) continue;
            this.mButtonItems[i].setTextSize(0, textSize);
        }
        this.set8thItemVisibility(false, true);
    }

    public void updateSelectedCharAndSelectNext(final String text) {
        this.streamOfShownItems().filter((Predicate)new Predicate<Button>(){

            public boolean test(Button view) {
                return view.isSelected();
            }
        }).findSingle().ifPresent((Consumer)new Consumer<Button>(){

            public void accept(Button button) {
                button.setText((CharSequence)text);
                InputView.this.performNextItemBy(button);
            }
        });
    }

    public void removeLastCharOfNumber() {
        this.findLastFilledTextItem().ifPresent((Consumer)new Consumer<Button>(){

            public void accept(Button cell) {
                cell.setText(null);
                cell.performClick();
            }
        });
    }

    public boolean isCompleted() {
        return this.streamOfShownItems().allMatch(this.notEmpty());
    }

    public boolean isNumberChanged() {
        String current = this.getNumber();
        return !current.equals(String.valueOf(this.mKeyMap.get(KEY_INIT_NUMBER)));
    }

    public void updateNumber(String number) {
        this.mKeyMap.put(KEY_INIT_NUMBER, number);
        char[] chars = number.toCharArray();
        for (int i = 0; i < this.mButtonItems.length; ++i) {
            Button view = this.mButtonItems[i];
            if (i < chars.length) {
                view.setText((CharSequence)String.valueOf(chars[i]));
                continue;
            }
            view.setText(null);
        }
        boolean charsOf8 = chars.length >= 8;
        this.set8thItemVisibility(charsOf8, !charsOf8);
    }

    public String getNumber() {
        return (String)this.streamOfShownItems().map((Function)new Function<Button, String>(){

            public String apply(Button textView) {
                return textView.getText().toString();
            }
        }).reduce((Object)"", (BiFunction)new BiFunction<String, String, String>(){

            public String apply(String char1, String char2) {
                return char1 + char2;
            }
        });
    }

    public void performFirstItem() {
        this.performItemSelected(this.mButtonItems[0]);
    }

    public void performLastItem() {
        this.findLastFilledTextItem().ifPresentOrElse((Consumer)new Consumer<Button>(){

            public void accept(Button button) {
                InputView.this.performNextItemBy(button);
            }
        }, new Runnable(){

            @Override
            public void run() {
                InputView.this.performItemSelected(InputView.this.mButtonItems[0]);
            }
        });
    }

    public void performNextItem() {
        Meta meta = this.getClickedMeta(null);
        if (meta.selectedIndex >= 0) {
            this.performNextItemBy(this.mButtonItems[meta.selectedIndex]);
        }
    }

    public void performCurrentItem() {
        Meta meta = this.getClickedMeta(null);
        if (meta.selectedIndex >= 0) {
            this.performItemSelected(this.mButtonItems[meta.selectedIndex]);
        }
    }

    public void set8thItemVisibility(boolean toShow, boolean clearText) {
        Button button8th = this.mButtonItems[7];
        boolean isShown = button8th.isShown();
        if (toShow) {
            if (!isShown) {
                button8th.setVisibility(0);
            }
            this.mButtonEndOf6.setVisibility(8);
            this.mButtonKeyOf6.setVisibility(0);
            this.mButtonItems[6] = this.mButtonKeyOf6;
        } else {
            if (isShown) {
                button8th.setVisibility(8);
            }
            this.mButtonEndOf6.setVisibility(0);
            this.mButtonKeyOf6.setVisibility(8);
            this.mButtonItems[6] = this.mButtonEndOf6;
        }
        if (clearText && !InputView.isButtonEmpty(button8th)) {
            button8th.setText(null);
        }
    }

    public boolean isLastItemSelected() {
        if (this.mButtonItems[7].isShown()) {
            return this.mButtonItems[7].isSelected();
        }
        return this.mButtonItems[6].isSelected();
    }

    public InputView addOnItemSelectedListener(OnItemSelectedListener listener) {
        this.mOnItemSelectedListeners.add(listener);
        return this;
    }

    private void performItemSelected(Button button) {
        button.performClick();
        this.setSelectedState(button);
    }

    private void performNextItemBy(Button cell) {
        List buttons = (List)this.streamOfShownItems().collect(Collectors.toList());
        int nextIndex = buttons.lastIndexOf(cell) + 1;
        int clickIndex = Math.min(nextIndex, buttons.size() - 1);
        this.performItemSelected((Button)buttons.get(clickIndex));
    }

    private Optional<Button> findLastFilledTextItem() {
        ArrayList<Button> reverse = new ArrayList<Button>(Arrays.asList(this.mButtonItems));
        Collections.reverse(reverse);
        return Stream.of(reverse).filter(this.shown()).filter(this.notEmpty()).findFirst();
    }

    private void clearSelectedState(Button item) {
        item.setSelected(false);
    }

    private void setSelectedState(Button cell) {
        for (Button btn : this.mButtonItems) {
            btn.setSelected(btn == cell);
        }
    }

    private Stream<Button> streamOfShownItems() {
        return Stream.of((Object[])this.mButtonItems).filter(this.shown());
    }

    private Predicate<Button> shown() {
        return new Predicate<Button>(){

            public boolean test(Button value) {
                return value.isShown();
            }
        };
    }

    private Predicate<Button> notEmpty() {
        return new Predicate<Button>(){

            public boolean test(Button button) {
                return !InputView.isButtonEmpty(button);
            }
        };
    }

    private Meta getClickedMeta(Button clicked) {
        short selected = -1;
        short current = 0;
        short length = 0;
        for (int i = 0; i < this.mButtonItems.length; ++i) {
            Button item = this.mButtonItems[i];
            if (item == clicked) {
                current = (short)i;
            }
            if (item.isSelected()) {
                selected = (short)i;
            }
            if (InputView.isButtonEmpty(item)) continue;
            length = (short)(length + 1);
        }
        return new Meta(selected, current, length);
    }

    private static boolean isButtonEmpty(Button button) {
        return button.getText().length() == 0;
    }

    public static interface OnItemSelectedListener {
        public void onSelected(int var1);
    }

    private static class Meta {
        final short selectedIndex;
        final short clickIndex;
        final short numberLength;

        private Meta(short selectedIndex, short clickIndex, short numberLength) {
            this.selectedIndex = selectedIndex;
            this.clickIndex = clickIndex;
            this.numberLength = numberLength;
        }
    }
}

