/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.vehiclekeyboard.core;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.parkingwang.vehiclekeyboard.core.KeyEntry;
import com.parkingwang.vehiclekeyboard.core.KeyboardEntry;
import com.parkingwang.vehiclekeyboard.core.KeyboardType;
import com.parkingwang.vehiclekeyboard.core.NumberType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class EngineRunner {
    private static final String TAG = "EngineRunner";
    private static final int DO_NOT_OPTIMIZE = -1;
    private static final String JS_FILE_NAME = "engine.js";
    private static final String SOURCE_NAME = "JavaScript";
    private static volatile String JS_TEXT = null;
    private Context mRhino;
    private ScriptableObject mEngineScope;
    private Function mUpdateFunction;

    public EngineRunner(android.content.Context context) {
        if (JS_TEXT == null) {
            JS_TEXT = EngineRunner.readJSContent(context);
        }
    }

    public void start() {
        if (this.mUpdateFunction != null) {
            return;
        }
        this.mRhino = Context.enter();
        this.mRhino.setOptimizationLevel(-1);
        this.mEngineScope = this.mRhino.initStandardObjects();
        this.mRhino.evaluateString((Scriptable)this.mEngineScope, JS_TEXT, SOURCE_NAME, 1, null);
        this.mRhino.evaluateString((Scriptable)this.mEngineScope, "var engine = new KeyboardEngine()", SOURCE_NAME, 1, null);
        Object object = this.mEngineScope.get("engine", (Scriptable)this.mEngineScope);
        if (!(object instanceof Scriptable)) {
            return;
        }
        Scriptable engine = (Scriptable)object;
        Object functionObject = engine.get("update", engine);
        if (!(functionObject instanceof Function)) {
            return;
        }
        this.mUpdateFunction = (Function)functionObject;
    }

    public void stop() {
        if (this.mUpdateFunction != null) {
            this.mUpdateFunction = null;
            Context.exit();
        }
    }

    public KeyboardEntry update(KeyboardType keyboardType, int showIndex, @NonNull String presetNumber, @NonNull NumberType numberType) {
        if (this.mUpdateFunction == null) {
            Log.e((String)TAG, (String)"You need to call start() before call update method");
            return null;
        }
        Object[] params = new Object[]{keyboardType.ordinal(), showIndex, presetNumber, numberType.ordinal()};
        return this.update(params);
    }

    @Nullable
    private KeyboardEntry update(Object[] params) {
        Object result = this.mUpdateFunction.call(this.mRhino, (Scriptable)this.mEngineScope, (Scriptable)this.mEngineScope, params);
        if (!(result instanceof NativeObject)) {
            return null;
        }
        return this.parseResult((NativeObject)result);
    }

    private KeyboardEntry parseResult(NativeObject nativeObject) {
        ArrayList<List<KeyEntry>> keyboard = new ArrayList<List<KeyEntry>>(5);
        int index = 0;
        String presetNumber = null;
        KeyboardType keyboardType = null;
        NumberType presetNumberType = NumberType.AUTO_DETECT;
        int numberLength = 0;
        int numberLimitLength = 0;
        NumberType detectedNumberType = NumberType.AUTO_DETECT;
        Set entrySet = nativeObject.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            if ("index".equals(key)) {
                index = (int)Context.toNumber(value);
                continue;
            }
            if ("presetNumber".equals(key)) {
                presetNumber = Context.toString(value);
                continue;
            }
            if ("keyboardType".equals(key)) {
                keyboardType = KeyboardType.values()[(int)Context.toNumber(value)];
                continue;
            }
            if ("numberType".equals(key)) {
                presetNumberType = NumberType.values()[(int)Context.toNumber(value)];
                continue;
            }
            if ("numberLength".equals(key)) {
                numberLength = (int)Context.toNumber(value);
                continue;
            }
            if ("numberLimitLength".equals(key)) {
                numberLimitLength = (int)Context.toNumber(value);
                continue;
            }
            if (key.startsWith("row")) {
                List<KeyEntry> keyList = this.getKeyEntries(entry);
                if (keyList == null) continue;
                keyboard.add(keyList);
                continue;
            }
            if (!"detectedNumberType".equals(key)) continue;
            detectedNumberType = NumberType.values()[(int)Context.toNumber(value)];
        }
        return new KeyboardEntry(index, presetNumber, keyboardType, presetNumberType, numberLength, numberLimitLength, keyboard, detectedNumberType);
    }

    @Nullable
    private List<KeyEntry> getKeyEntries(Map.Entry<Object, Object> entry) {
        if (!(entry.getValue() instanceof NativeArray)) {
            return null;
        }
        NativeArray nativeArray = (NativeArray)entry.getValue();
        if (nativeArray.isEmpty()) {
            return null;
        }
        ArrayList<KeyEntry> keyList = new ArrayList<KeyEntry>();
        int size = nativeArray.size();
        for (int i = 0; i < size; ++i) {
            NativeObject elem = (NativeObject)nativeArray.get(i);
            keyList.add(new KeyEntry(Context.toString((Object)elem.get((Object)"text")), (int)Context.toNumber((Object)elem.get((Object)"keyCode")), Context.toBoolean((Object)elem.get((Object)"enabled")), Context.toBoolean((Object)elem.get((Object)"isFunKey"))));
        }
        return keyList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readJSContent(android.content.Context context) {
        InputStream is = null;
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = null;
        try {
            String line;
            is = context.getAssets().open(JS_FILE_NAME);
            reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }
}

