/*
 * Decompiled with CFR 0.152.
 */
package com.parasoft.environmentmanager.jenkins;

import com.parasoft.em.client.api.EventMonitor;
import com.parasoft.em.client.impl.EnvironmentCopyImpl;
import com.parasoft.em.client.impl.EnvironmentsImpl;
import com.parasoft.em.client.impl.ProvisionsImpl;
import com.parasoft.em.client.impl.ServersImpl;
import com.parasoft.em.client.impl.SystemsImpl;
import com.parasoft.environmentmanager.jenkins.EnvironmentManagerPlugin;
import com.parasoft.environmentmanager.jenkins.ProvisioningEventAction;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class EnvironmentManagerBuilder
extends Builder {
    private int systemId;
    private int environmentId;
    private int instanceId;
    private boolean copyToServer;
    private String newEnvironmentName;
    private String serverType;
    private int serverId;
    private String serverHost;
    private String serverName;
    private boolean copyDataRepo;
    private String repoType;
    private String repoHost;
    private int repoPort;
    private String repoUsername;
    private String repoPassword;
    private boolean abortOnFailure;

    @DataBoundConstructor
    public EnvironmentManagerBuilder(int systemId, int environmentId, int instanceId, boolean copyToServer, String newEnvironmentName, String serverType, int serverId, String serverHost, String serverName, boolean copyDataRepo, String repoType, String repoHost, int repoPort, String repoUsername, String repoPassword, boolean abortOnFailure) {
        this.systemId = systemId;
        this.environmentId = environmentId;
        this.instanceId = instanceId;
        this.copyToServer = copyToServer;
        this.newEnvironmentName = newEnvironmentName;
        this.serverType = serverType;
        this.serverId = serverId;
        this.serverHost = serverHost;
        this.serverName = serverName;
        this.copyDataRepo = copyDataRepo;
        this.repoType = repoType;
        this.repoHost = repoHost;
        this.repoPort = repoPort;
        this.repoUsername = repoUsername;
        this.repoPassword = repoPassword;
        this.abortOnFailure = abortOnFailure;
    }

    public int getSystemId() {
        return this.systemId;
    }

    public int getEnvironmentId() {
        return this.environmentId;
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    public boolean isCopyToServer() {
        return this.copyToServer;
    }

    public String getNewEnvironmentName() {
        return this.newEnvironmentName;
    }

    public boolean isServerType(String type) {
        if (this.serverType == null || this.serverType.isEmpty()) {
            return "registered".equals(type);
        }
        return this.serverType.equals(type);
    }

    public int getServerId() {
        return this.serverId;
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public String getServerName() {
        return this.serverName;
    }

    public boolean isCopyDataRepo() {
        return this.copyDataRepo;
    }

    public boolean isRepoType(String type) {
        if (this.repoType == null || this.repoType.isEmpty()) {
            return "current".equals(type);
        }
        return this.repoType.equals(type);
    }

    public String getRepoHost() {
        return this.repoHost;
    }

    public int getRepoPort() {
        return this.repoPort == 0 ? 2424 : this.repoPort;
    }

    public String getRepoUsername() {
        return this.repoUsername == null ? "admin" : this.repoUsername;
    }

    public String getRepoPassword() {
        return this.repoPassword == null ? "admin" : this.repoPassword;
    }

    public boolean isAbortOnFailure() {
        return this.abortOnFailure;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, final BuildListener listener) throws InterruptedException, IOException {
        EnvironmentManagerPlugin.EnvironmentManagerPluginDescriptor pluginDescriptor = EnvironmentManagerPlugin.getEnvironmentManagerPluginDescriptor();
        String emUrl = pluginDescriptor.getEmUrl();
        String username = pluginDescriptor.getUsername();
        Secret password = pluginDescriptor.getPassword();
        EnvVars envVars = build.getEnvironment((TaskListener)listener);
        int targetEnvironmentId = this.environmentId;
        int targetInstanceId = this.instanceId;
        EnvironmentsImpl environments = new EnvironmentsImpl(emUrl, username, password.getPlainText());
        JSONObject instance = environments.getEnvironmentInstance(this.environmentId, this.instanceId);
        if (this.copyToServer) {
            JSONObject targetServer = null;
            int targetServerId = 0;
            String targetServerName = envVars.expand(this.serverName);
            String targetServerHost = envVars.expand(this.serverHost);
            boolean waitingNotFoundMessageShown = false;
            boolean waitingOfflineMessageShown = false;
            String status = null;
            while (targetServerId == 0) {
                ServersImpl servers;
                JSONObject response;
                if (this.isServerType("registered")) {
                    targetServerId = this.serverId;
                }
                if ((response = (servers = new ServersImpl(emUrl, username, password.getPlainText())).getServers()).has("servers")) {
                    JSONArray envArray = response.getJSONArray("servers");
                    for (Object o : envArray) {
                        JSONObject server = (JSONObject)o;
                        if (this.isServerType("registered")) {
                            int id = server.getInt("id");
                            if (id != this.serverId) continue;
                            targetServer = server;
                            status = server.optString("status");
                            continue;
                        }
                        if (this.isServerType("name")) {
                            String name = server.getString("name");
                            if (name.indexOf(targetServerName) >= 0) {
                                targetServerId = server.getInt("id");
                                targetServer = server;
                                status = server.optString("status");
                            }
                            if (!name.equalsIgnoreCase(targetServerName)) continue;
                            break;
                        }
                        if (!this.isServerType("host")) continue;
                        String host = server.getString("host");
                        if (host.indexOf(targetServerHost) >= 0) {
                            targetServerId = server.getInt("id");
                            targetServer = server;
                            status = server.optString("status");
                        }
                        if (!host.equalsIgnoreCase(targetServerHost)) continue;
                        break;
                    }
                }
                if (targetServerId == 0 && !waitingNotFoundMessageShown) {
                    String errorMessage = "WARNING:  Could not find any Virtualize servers matching ";
                    if (this.isServerType("name")) {
                        errorMessage = errorMessage + "name:  " + targetServerName;
                    } else if (this.isServerType("host")) {
                        errorMessage = errorMessage + "host:  " + targetServerHost;
                    }
                    listener.getLogger().println(errorMessage);
                    listener.getLogger().println("Waiting for a matching Virtualize server to register with the Continuous Testing Platform...");
                    waitingNotFoundMessageShown = true;
                }
                if ("OFFLINE".equals(status) || "REFRESHING".equals(status)) {
                    targetServerId = 0;
                    if (!waitingOfflineMessageShown) {
                        listener.getLogger().println("Waiting for Virtualize server to come online...");
                        waitingOfflineMessageShown = true;
                    }
                }
                Thread.sleep(10000L);
            }
            EnvironmentCopyImpl environmentCopy = new EnvironmentCopyImpl(emUrl, username, password.getPlainText());
            JSONObject dataRepoSettings = null;
            if (this.isRepoType("target")) {
                dataRepoSettings = new JSONObject();
                dataRepoSettings.put((Object)"host", (Object)targetServer.getString("host"));
            } else if (this.isRepoType("custom")) {
                dataRepoSettings = new JSONObject();
                dataRepoSettings.put((Object)"host", (Object)this.getRepoHost());
            }
            if (dataRepoSettings != null) {
                dataRepoSettings.put((Object)"port", (Object)this.getRepoPort());
                dataRepoSettings.put((Object)"username", (Object)this.getRepoUsername());
                dataRepoSettings.put((Object)"password", (Object)this.getRepoPassword());
            }
            JSONObject copyEvent = environmentCopy.createEnvironmentCopy(this.environmentId, targetServerId, envVars.expand(this.newEnvironmentName), this.copyDataRepo, dataRepoSettings);
            boolean copyResult = environmentCopy.monitorEvent(copyEvent, new EventMonitor(){

                @Override
                public void logMessage(String message) {
                    listener.getLogger().println(message);
                }
            });
            JSONObject copyStatus = environmentCopy.removeCopyStatus(copyEvent.getInt("id"));
            if (!copyResult) {
                return false;
            }
            targetEnvironmentId = copyStatus.getInt("environmentId");
            targetInstanceId = 0;
            String instanceName = instance.getString("name");
            JSONObject copiedInstances = environments.getEnvironmentInstances(targetEnvironmentId);
            if (copiedInstances.has("instances")) {
                JSONArray instArray = copiedInstances.getJSONArray("instances");
                for (int i = 0; i < instArray.size(); ++i) {
                    JSONObject inst = instArray.getJSONObject(i);
                    if (!instanceName.equals(inst.getString("name"))) continue;
                    targetInstanceId = inst.getInt("id");
                    break;
                }
            }
            if (targetInstanceId == 0) {
                listener.getLogger().println("Unable to find environment instance named \"" + instanceName + "\" in the copied environment.");
                return false;
            }
        }
        listener.getLogger().println("Executing provisioning action on " + emUrl);
        ProvisionsImpl provisions = new ProvisionsImpl(emUrl, username, password.getPlainText());
        JSONObject event = provisions.createProvisionEvent(targetEnvironmentId, targetInstanceId, this.abortOnFailure);
        boolean result = provisions.monitorEvent(event, new EventMonitor(){

            @Override
            public void logMessage(String message) {
                listener.getLogger().println(message);
            }
        });
        String baseUrl = emUrl;
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        JSONObject eventResult = provisions.getProvisions(event.getInt("eventId"));
        JSONArray steps = eventResult.getJSONArray("steps");
        int failed = 0;
        for (int i = 0; i < steps.size(); ++i) {
            JSONObject step = steps.getJSONObject(i);
            if (!"error".equals(step.getString("result"))) continue;
            ++failed;
        }
        String environmentUrl = baseUrl + "environments/" + targetEnvironmentId;
        build.addAction((Action)new ProvisioningEventAction(build, instance.getString("name"), environmentUrl, steps.size(), failed));
        return result;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Deploy an environment";
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            req.bindJSON((Object)this, json);
            this.save();
            return super.configure(req, json);
        }

        public ListBoxModel doFillSystemIdItems() {
            ListBoxModel m = new ListBoxModel();
            try {
                SystemsImpl systems;
                JSONObject envs;
                EnvironmentManagerPlugin.EnvironmentManagerPluginDescriptor pluginDescriptor = EnvironmentManagerPlugin.getEnvironmentManagerPluginDescriptor();
                String emUrl = pluginDescriptor.getEmUrl();
                String username = pluginDescriptor.getUsername();
                Secret password = pluginDescriptor.getPassword();
                if (emUrl != null && (envs = (systems = new SystemsImpl(emUrl, username, password.getPlainText())).getSystems()).has("systems")) {
                    JSONArray sysArray = envs.getJSONArray("systems");
                    for (Object o : sysArray) {
                        JSONObject system = (JSONObject)o;
                        String name = system.getString("name");
                        if (system.has("version")) {
                            name = name + " (" + system.getString("version") + ")";
                        }
                        m.add(name, system.getString("id"));
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return m;
        }

        public ListBoxModel doFillEnvironmentIdItems(@QueryParameter int systemId) {
            ListBoxModel m = new ListBoxModel();
            try {
                EnvironmentManagerPlugin.EnvironmentManagerPluginDescriptor pluginDescriptor = EnvironmentManagerPlugin.getEnvironmentManagerPluginDescriptor();
                String emUrl = pluginDescriptor.getEmUrl();
                String username = pluginDescriptor.getUsername();
                Secret password = pluginDescriptor.getPassword();
                if (emUrl != null) {
                    EnvironmentsImpl environments;
                    JSONArray sysArray;
                    SystemsImpl systems;
                    JSONObject envs;
                    if (systemId == 0 && (envs = (systems = new SystemsImpl(emUrl, username, password.getPlainText())).getSystems()).has("systems") && (sysArray = envs.getJSONArray("systems")).size() > 0) {
                        JSONObject system = sysArray.getJSONObject(0);
                        systemId = system.getInt("id");
                    }
                    if ((envs = (environments = new EnvironmentsImpl(emUrl, username, password.getPlainText())).getEnvironments()).has("environments")) {
                        JSONArray envArray = envs.getJSONArray("environments");
                        for (Object o : envArray) {
                            JSONObject env = (JSONObject)o;
                            if (env.getInt("systemId") != systemId) continue;
                            String name = env.getString("name");
                            if (env.has("version")) {
                                name = name + " (" + env.getString("version") + ")";
                            }
                            m.add(name, env.getString("id"));
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return m;
        }

        public ListBoxModel doFillInstanceIdItems(@QueryParameter int systemId, @QueryParameter int environmentId) {
            ListBoxModel m = new ListBoxModel();
            try {
                JSONObject instances;
                JSONArray sysArray;
                SystemsImpl systems;
                JSONObject envs;
                EnvironmentManagerPlugin.EnvironmentManagerPluginDescriptor pluginDescriptor = EnvironmentManagerPlugin.getEnvironmentManagerPluginDescriptor();
                String emUrl = pluginDescriptor.getEmUrl();
                String username = pluginDescriptor.getUsername();
                Secret password = pluginDescriptor.getPassword();
                if (systemId == 0 && (envs = (systems = new SystemsImpl(emUrl, username, password.getPlainText())).getSystems()).has("systems") && (sysArray = envs.getJSONArray("systems")).size() > 0) {
                    JSONObject system = sysArray.getJSONObject(0);
                    systemId = system.getInt("id");
                }
                EnvironmentsImpl environments = new EnvironmentsImpl(emUrl, username, password.getPlainText());
                if (environmentId == 0) {
                    envs = environments.getEnvironments();
                    if (envs.has("environments")) {
                        JSONArray envArray = envs.getJSONArray("environments");
                        for (Object o : envArray) {
                            JSONObject env = (JSONObject)o;
                            if (env.getInt("systemId") != systemId) continue;
                            environmentId = env.getInt("id");
                            break;
                        }
                    }
                } else {
                    JSONObject env = environments.getEnvironment(environmentId);
                    if (env.getInt("systemId") != systemId) {
                        return m;
                    }
                }
                if ((instances = environments.getEnvironmentInstances(environmentId)).has("instances")) {
                    JSONArray instArray = instances.getJSONArray("instances");
                    for (Object o : instArray) {
                        JSONObject inst = (JSONObject)o;
                        m.add(inst.getString("name"), inst.getString("id"));
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return m;
        }

        public ListBoxModel doFillServerIdItems() {
            ListBoxModel m = new ListBoxModel();
            try {
                ServersImpl servers;
                JSONObject response;
                EnvironmentManagerPlugin.EnvironmentManagerPluginDescriptor pluginDescriptor = EnvironmentManagerPlugin.getEnvironmentManagerPluginDescriptor();
                String emUrl = pluginDescriptor.getEmUrl();
                String username = pluginDescriptor.getUsername();
                Secret password = pluginDescriptor.getPassword();
                if (emUrl != null && (response = (servers = new ServersImpl(emUrl, username, password.getPlainText())).getServers()).has("servers")) {
                    JSONArray envArray = response.getJSONArray("servers");
                    for (Object o : envArray) {
                        String host;
                        JSONObject server = (JSONObject)o;
                        String name = server.getString("name");
                        if (!name.equals(host = server.getString("host"))) {
                            name = name + " (" + host + ':' + server.getInt("port") + ')';
                        }
                        m.add(name, server.getString("id"));
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return m;
        }
    }
}

