/*
 * Decompiled with CFR 0.152.
 */
package com.parasoft.environmentmanager.jenkins;

import com.parasoft.em.client.impl.EnvironmentsImpl;
import com.parasoft.em.client.impl.SystemsImpl;
import com.parasoft.environmentmanager.jenkins.EnvironmentManagerPlugin;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class DeleteEnvironmentBuilder
extends Builder {
    private int systemId;
    private String environmentName;

    @DataBoundConstructor
    public DeleteEnvironmentBuilder(int systemId, String environmentName) {
        this.systemId = systemId;
        this.environmentName = environmentName;
    }

    public int getSystemId() {
        return this.systemId;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        EnvironmentManagerPlugin.EnvironmentManagerPluginDescriptor pluginDescriptor = EnvironmentManagerPlugin.getEnvironmentManagerPluginDescriptor();
        String emUrl = pluginDescriptor.getEmUrl();
        String username = pluginDescriptor.getUsername();
        Secret password = pluginDescriptor.getPassword();
        EnvVars envVars = build.getEnvironment((TaskListener)listener);
        String nameToDelete = envVars.expand(this.environmentName);
        EnvironmentsImpl environments = new EnvironmentsImpl(emUrl, username, password.getPlainText());
        JSONObject environmentsJSON = environments.getEnvironments();
        JSONArray environmentsJSONArray = environmentsJSON.getJSONArray("environments");
        boolean error = false;
        boolean match = false;
        for (int i = 0; i < environmentsJSONArray.size(); ++i) {
            try {
                JSONObject environmentJSON = environmentsJSONArray.getJSONObject(i);
                if (environmentJSON.getLong("systemId") != (long)this.systemId || !environmentJSON.getString("name").equals(nameToDelete)) continue;
                match = true;
                listener.getLogger().println("Deleting environment \"" + environmentJSON.getString("name") + "\" (id " + environmentJSON.getLong("id") + ")...");
                environments.deleteEnvironment(environmentJSON.getLong("id"), true);
                continue;
            }
            catch (IOException e) {
                listener.getLogger().println(e.getMessage());
                error = true;
            }
        }
        if (!match) {
            listener.getLogger().println("No environments within the selected system match name:  " + nameToDelete);
        }
        return match && !error;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Destroy an environment";
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            req.bindJSON((Object)this, json);
            this.save();
            return super.configure(req, json);
        }

        public ListBoxModel doFillSystemIdItems() {
            ListBoxModel m = new ListBoxModel();
            try {
                SystemsImpl systems;
                JSONObject envs;
                EnvironmentManagerPlugin.EnvironmentManagerPluginDescriptor pluginDescriptor = EnvironmentManagerPlugin.getEnvironmentManagerPluginDescriptor();
                String emUrl = pluginDescriptor.getEmUrl();
                String username = pluginDescriptor.getUsername();
                Secret password = pluginDescriptor.getPassword();
                if (emUrl != null && (envs = (systems = new SystemsImpl(emUrl, username, password.getPlainText())).getSystems()).has("systems")) {
                    JSONArray envArray = envs.getJSONArray("systems");
                    for (Object o : envArray) {
                        JSONObject system = (JSONObject)o;
                        String name = system.getString("name");
                        if (system.has("version")) {
                            name = name + " (" + system.getString("version") + ")";
                        }
                        m.add(name, system.getString("id"));
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return m;
        }
    }
}

