/*
 * Decompiled with CFR 0.152.
 */
package com.parasoft.em.client.impl;

import com.parasoft.em.client.api.EventMonitor;
import com.parasoft.em.client.api.Jobs;
import com.parasoft.em.client.impl.EnvironmentsImpl;
import com.parasoft.em.client.impl.JSONClient;
import com.parasoft.em.client.impl.SystemsImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.GeneralSecurityException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.util.URIUtil;

public class JobsImpl
extends JSONClient
implements Jobs {
    public JobsImpl(String emUrl, String username, String password) {
        super(emUrl, username, password);
    }

    @Override
    public JSONObject getJobs() throws IOException {
        return this.doGet("api/v2/jobs", "fields=id%2Cname", true);
    }

    @Override
    public JSONObject getJobsByName(String name) throws IOException {
        return this.doGet("api/v2/jobs", "name=" + URIUtil.encodeWithinQuery((String)name, (String)"UTF-8"), true);
    }

    @Override
    public JSONObject getJob(long jobId) throws IOException {
        return this.doGet("api/v2/jobs/" + jobId);
    }

    @Override
    public JSONObject executeJob(long jobId) throws IOException {
        return this.doPost("api/v2/jobs/" + jobId + "/histories", null);
    }

    @Override
    public boolean monitorExecution(JSONObject history, EventMonitor monitor) throws IOException {
        boolean result;
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        long jobId = history.getLong("jobId");
        long historyId = history.getLong("id");
        JSONObject context = history.optJSONObject("context");
        if (context != null) {
            SystemsImpl systems = new SystemsImpl(this.baseUrl, this.username, this.password);
            EnvironmentsImpl environments = new EnvironmentsImpl(this.baseUrl, this.username, this.password);
            long systemId = context.optLong("systemId");
            long environmentId = context.optLong("environmentId");
            long instanceId = context.optLong("environmentInstanceId");
            if (systemId > 0L) {
                JSONObject system = systems.getSystem(systemId);
                monitor.logMessage("    Context System: " + system.getString("name"));
            }
            if (environmentId > 0L) {
                JSONObject environment = environments.getEnvironment(environmentId);
                monitor.logMessage("    Context Environment: " + environment.getString("name"));
                if (instanceId > 0L) {
                    JSONObject instance = environments.getEnvironmentInstance(environmentId, instanceId);
                    monitor.logMessage("    Context Environment Instance: " + instance.getString("name"));
                }
            }
        }
        String lastStatus = null;
        String status = history.optString("status");
        int lastPercentage = 0;
        int percentage = 0;
        while ("WAITING".equalsIgnoreCase(status) || "RUNNING".equalsIgnoreCase(status)) {
            if (status != null) {
                if (!status.equals(lastStatus)) {
                    if ("WAITING".equalsIgnoreCase(status)) {
                        monitor.logMessage("Waiting...");
                    } else if ("RUNNING".equalsIgnoreCase(status)) {
                        monitor.logMessage("Running...");
                    } else {
                        monitor.logMessage(status);
                    }
                    lastStatus = status;
                }
                if (percentage != lastPercentage) {
                    monitor.logMessage(percentage + "%");
                    lastPercentage = percentage;
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException environmentId) {
                // empty catch block
            }
            history = this.getHistory(jobId, historyId);
            status = history.optString("status");
            percentage = history.optInt("percentage");
        }
        if ("PASSED".equalsIgnoreCase(status)) {
            monitor.logMessage("All tests passed.");
            result = true;
        } else {
            result = false;
        }
        if ("FAILED".equalsIgnoreCase(status)) {
            monitor.logMessage("Some tests failed.");
        } else if ("CANCELED".equalsIgnoreCase(status)) {
            monitor.logMessage("Test execution was canceled.");
        }
        JSONArray reportIds = history.optJSONArray("reportIds");
        if (reportIds != null) {
            for (int i = 0; i < reportIds.size(); ++i) {
                monitor.logMessage(this.baseUrl + "testreport/" + reportIds.getLong(i) + "/report.html");
            }
        }
        return result;
    }

    @Override
    public JSONObject getHistory(long jobId, long historyId) throws IOException {
        return this.doGet("api/v2/jobs/" + jobId + "/histories/" + historyId);
    }

    @Override
    public JSONObject deleteHistory(long jobId, long historyId) throws IOException {
        return this.doDelete("api/v2/jobs/" + jobId + "/histories/" + historyId);
    }

    @Override
    public InputStream download(String urlPath) throws IOException {
        URL url = new URL(this.baseUrl + urlPath);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        if (connection instanceof HttpsURLConnection) {
            HostnameVerifier hostnameVerifier = null;
            try {
                if (this.trustAllSslSocketFactory == null) {
                    this.trustAllSslSocketFactory = JobsImpl.makeTrustAllSslSocketFactory();
                }
                hostnameVerifier = new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                };
                ((HttpsURLConnection)connection).setSSLSocketFactory(this.trustAllSslSocketFactory);
                ((HttpsURLConnection)connection).setHostnameVerifier(hostnameVerifier);
            }
            catch (GeneralSecurityException e) {
                e.printStackTrace();
            }
        }
        connection.setDoOutput(true);
        if (this.username != null) {
            String encoding = this.username + ":" + this.password;
            encoding = Base64.encodeBase64String((byte[])encoding.getBytes("UTF-8"));
            connection.setRequestProperty("Authorization", "Basic " + encoding);
        }
        connection.setRequestMethod("GET");
        connection.setConnectTimeout(60000);
        connection.setReadTimeout(300000);
        return connection.getInputStream();
    }
}

