/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.bootstrap;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;

final class FormatterCommandRunner {
    private static final Pattern SYNTAX_ERROR_PATTERN = Pattern.compile(":\\d+:\\d+:\\serror:\\s");

    FormatterCommandRunner() {
    }

    static Optional<String> runWithStdin(List<String> command, String input) throws IOException {
        Process process = new ProcessBuilder(new String[0]).command(command).start();
        try (OutputStream outputStream = process.getOutputStream();){
            outputStream.write(input.getBytes(StandardCharsets.UTF_8));
        }
        String stdout = FormatterCommandRunner.readToString(process.getInputStream());
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while executing command", e);
        }
        if (process.exitValue() != 0) {
            String stderr = FormatterCommandRunner.readToString(process.getErrorStream());
            if (FormatterCommandRunner.isSyntaxError(stderr)) {
                return Optional.empty();
            }
            throw new IOException(FormatterCommandRunner.getErrorMessage(command, stdout, stderr));
        }
        return Optional.of(stdout);
    }

    private static boolean isSyntaxError(String stderr) {
        return SYNTAX_ERROR_PATTERN.matcher(stderr).find();
    }

    private static String readToString(InputStream input) throws IOException {
        try (InputStream inputStream = input;){
            String string = new String(input.readAllBytes(), StandardCharsets.UTF_8);
            return string;
        }
    }

    private static String getErrorMessage(List<String> command, String stdout, String stderr) {
        return String.join((CharSequence)"\n", "Command terminated with exit value 1", "Command: " + String.join((CharSequence)" ", command), "Stdout:", stdout, "Stderr:", stderr);
    }
}

