/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.api.errors;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.palantir.conjure.java.api.errors.ImmutableSerializableError;
import com.palantir.conjure.java.api.errors.ServiceException;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Value;

@JsonDeserialize(builder=Builder.class)
@JsonSerialize(as=ImmutableSerializableError.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@Value.Immutable
@Value.Style(overshadowImplementation=false)
public abstract class SerializableError
implements Serializable {
    @JsonProperty(value="errorCode")
    @Value.Default
    public String errorCode() {
        return this.getExceptionClass().orElseThrow(() -> new SafeIllegalStateException("Expected either 'errorCode' or 'exceptionClass' to be set", new Arg[0]));
    }

    @JsonProperty(value="errorName")
    @Value.Default
    public String errorName() {
        return this.getMessage().orElseThrow(() -> new SafeIllegalStateException("Expected either 'errorName' or 'message' to be set", new Arg[0]));
    }

    @JsonProperty(value="errorInstanceId")
    @Value.Default
    public String errorInstanceId() {
        return "";
    }

    public abstract Map<String, String> parameters();

    @Deprecated
    @JsonProperty(value="exceptionClass", access=JsonProperty.Access.WRITE_ONLY)
    @Value.Auxiliary
    abstract Optional<String> getExceptionClass();

    @Deprecated
    @JsonProperty(value="message", access=JsonProperty.Access.WRITE_ONLY)
    @Value.Auxiliary
    abstract Optional<String> getMessage();

    public static SerializableError forException(ServiceException exception) {
        Builder builder = new Builder().errorCode(exception.getErrorType().code().name()).errorName(exception.getErrorType().name()).errorInstanceId(exception.getErrorInstanceId());
        for (Arg<?> arg : exception.getArgs()) {
            builder.putParameters(arg.getName(), Objects.toString(arg.getValue()));
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends ImmutableSerializableError.Builder {
    }
}

