/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.api.errors;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.SafeLoggable;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public abstract class QosException
extends RuntimeException {
    private QosException(String message) {
        super(message);
    }

    public abstract <T> T accept(Visitor<T> var1);

    public static Throttle throttle() {
        return new Throttle(Optional.empty());
    }

    public static Throttle throttle(Duration duration) {
        return new Throttle(Optional.of(duration));
    }

    public static RetryOther retryOther(URL redirectTo) {
        return new RetryOther(redirectTo);
    }

    public static Unavailable unavailable() {
        return new Unavailable();
    }

    public static final class Unavailable
    extends QosException {
        private Unavailable() {
            super("Server unavailable");
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class RetryOther
    extends QosException
    implements SafeLoggable {
        private final URL redirectTo;

        private RetryOther(URL redirectTo) {
            super("Suggesting request retry against: " + redirectTo.toString());
            this.redirectTo = redirectTo;
        }

        public URL getRedirectTo() {
            return this.redirectTo;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visit(this);
        }

        public String getLogMessage() {
            return this.getClass().getSimpleName() + ": Requesting retry";
        }

        public List<Arg<?>> getArgs() {
            ArrayList args = new ArrayList();
            args.add((Arg<?>)SafeArg.of((String)"redirectTo", (Object)this.redirectTo));
            return args;
        }
    }

    public static final class Throttle
    extends QosException {
        private final Optional<Duration> retryAfter;

        private Throttle(Optional<Duration> retryAfter) {
            super("Suggesting request throttling with optional retryAfter duration: " + retryAfter);
            this.retryAfter = retryAfter;
        }

        public Optional<Duration> getRetryAfter() {
            return this.retryAfter;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static interface Visitor<T> {
        public T visit(Throttle var1);

        public T visit(RetryOther var1);

        public T visit(Unavailable var1);
    }
}

