/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.api.errors;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.conjure.java.api.errors.ErrorType;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ErrorType", generator="Immutables")
@Immutable
final class ImmutableErrorType
extends ErrorType {
    private final ErrorType.Code code;
    private final String name;
    private final int httpErrorCode;

    private ImmutableErrorType(ErrorType.Code code, String name, int httpErrorCode) {
        this.code = code;
        this.name = name;
        this.httpErrorCode = httpErrorCode;
    }

    @Override
    public ErrorType.Code code() {
        return this.code;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int httpErrorCode() {
        return this.httpErrorCode;
    }

    public final ImmutableErrorType withCode(ErrorType.Code value) {
        if (this.code == value) {
            return this;
        }
        ErrorType.Code newValue = Objects.requireNonNull(value, "code");
        if (this.code.equals((Object)newValue)) {
            return this;
        }
        return ImmutableErrorType.validate(new ImmutableErrorType(newValue, this.name, this.httpErrorCode));
    }

    public final ImmutableErrorType withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return ImmutableErrorType.validate(new ImmutableErrorType(this.code, newValue, this.httpErrorCode));
    }

    public final ImmutableErrorType withHttpErrorCode(int value) {
        if (this.httpErrorCode == value) {
            return this;
        }
        return ImmutableErrorType.validate(new ImmutableErrorType(this.code, this.name, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableErrorType && this.equalTo((ImmutableErrorType)another);
    }

    private boolean equalTo(ImmutableErrorType another) {
        return this.code.equals((Object)another.code) && this.name.equals(another.name) && this.httpErrorCode == another.httpErrorCode;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.code.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.httpErrorCode;
        return h;
    }

    public String toString() {
        return "ErrorType{code=" + (Object)((Object)this.code) + ", name=" + this.name + ", httpErrorCode=" + this.httpErrorCode + "}";
    }

    private static ImmutableErrorType validate(ImmutableErrorType instance) {
        instance.check();
        return instance;
    }

    public static ErrorType copyOf(ErrorType instance) {
        if (instance instanceof ImmutableErrorType) {
            return (ImmutableErrorType)instance;
        }
        return ImmutableErrorType.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ErrorType", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CODE = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_HTTP_ERROR_CODE = 4L;
        private long initBits = 7L;
        @Nullable
        private ErrorType.Code code;
        @Nullable
        private String name;
        private int httpErrorCode;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ErrorType instance) {
            Objects.requireNonNull(instance, "instance");
            this.code(instance.code());
            this.name(instance.name());
            this.httpErrorCode(instance.httpErrorCode());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder code(ErrorType.Code code) {
            this.code = Objects.requireNonNull(code, "code");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder httpErrorCode(int httpErrorCode) {
            this.httpErrorCode = httpErrorCode;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ErrorType build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableErrorType.validate(new ImmutableErrorType(this.code, this.name, this.httpErrorCode));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("code");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("httpErrorCode");
            }
            return "Cannot build ErrorType, some of required attributes are not set " + attributes;
        }
    }
}

