/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.mux;

import org.eclipse.jetty.websocket.common.OpCode;
import org.eclipse.jetty.websocket.common.WebSocketFrame;

public class MuxedFrame
extends WebSocketFrame {
    private long channelId = -1L;

    public MuxedFrame() {
    }

    public MuxedFrame(MuxedFrame frame) {
        super(frame);
        this.channelId = frame.channelId;
    }

    public long getChannelId() {
        return this.channelId;
    }

    @Override
    public void reset() {
        super.reset();
        this.channelId = -1L;
    }

    public void setChannelId(long channelId) {
        this.channelId = channelId;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(OpCode.name(this.getOpCode()));
        b.append('[');
        b.append("channel=").append(this.channelId);
        b.append(",len=").append(this.getPayloadLength());
        b.append(",fin=").append(this.isFin());
        b.append(",rsv=");
        b.append(this.isRsv1() ? (char)'1' : '.');
        b.append(this.isRsv2() ? (char)'1' : '.');
        b.append(this.isRsv3() ? (char)'1' : '.');
        b.append(",continuation=").append(this.isContinuation());
        b.append(']');
        return b.toString();
    }
}

