/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.template.web;

import com.ovea.tajin.framework.template.web.LocaleProvider;
import com.ovea.tajin.framework.template.web.MarkupData;
import com.ovea.tajin.framework.template.web.MarkupDataBuilder;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

final class StaticMarkupDataBuilder
implements MarkupDataBuilder {
    private final ConcurrentMap<String, MarkupData> cache = new ConcurrentHashMap<String, MarkupData>();
    private final MarkupDataBuilder markupDataBuilder;
    private final LocaleProvider localeProvider;

    StaticMarkupDataBuilder(MarkupDataBuilder markupDataBuilder, LocaleProvider localeProvider) {
        this.markupDataBuilder = markupDataBuilder;
        this.localeProvider = localeProvider;
    }

    @Override
    public MarkupData build(HttpServletRequest request, HttpServletResponse response, String path) {
        MarkupData old;
        String key = String.valueOf(path) + this.localeProvider.get(request);
        MarkupData markupData = (MarkupData)this.cache.get(key);
        if (markupData == null && (old = this.cache.putIfAbsent(key, markupData = this.markupDataBuilder.build(request, response, path))) != null) {
            markupData = old;
        }
        return markupData;
    }
}

