/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.template;

import com.ovea.tajin.framework.io.Resource;
import com.ovea.tajin.framework.template.ResolvedTemplate;
import com.ovea.tajin.framework.template.TemplateCompiler;
import com.ovea.tajin.framework.template.TemplateCompilerException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class CachingTemplateCompiler
implements TemplateCompiler {
    private final ConcurrentMap<Resource, ResolvedTemplate> cache = new ConcurrentHashMap<Resource, ResolvedTemplate>();
    private final TemplateCompiler templateCompiler;

    public CachingTemplateCompiler(TemplateCompiler templateCompiler) {
        this.templateCompiler = templateCompiler;
    }

    @Override
    public ResolvedTemplate compile(Resource location) throws TemplateCompilerException {
        ResolvedTemplate old;
        ResolvedTemplate template = (ResolvedTemplate)this.cache.get(location);
        if (template == null && (old = this.cache.putIfAbsent(location, template = this.templateCompiler.compile(location))) != null) {
            template = old;
        }
        return template;
    }
}

