/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.jmx;

import com.mycila.jmx.BeanProperty;
import com.mycila.jmx.ClassUtils;
import com.mycila.jmx.ExceptionUtils;
import com.mycila.jmx.Role;
import java.lang.reflect.AccessibleObject;
import java.util.Hashtable;
import javax.management.Descriptor;
import javax.management.DynamicMBean;
import javax.management.MXBean;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

final class JmxUtils {
    private static final String MBEAN_SUFFIX = "MBean";
    private static final String MXBEAN_SUFFIX = "MXBean";
    private static final String MXBEAN_ANNOTATION_CLASS_NAME = "javax.management.MXBean";
    private static final boolean mxBeanAnnotationAvailable = ClassUtils.isPresent("javax.management.MXBean", JmxUtils.class.getClassLoader());

    private JmxUtils() {
    }

    public static ReflectionException rethrow(Throwable e) throws ReflectionException {
        throw new ReflectionException(ExceptionUtils.rethrowOrWrap(e), e.getMessage());
    }

    public static ObjectName appendIdentityToObjectName(ObjectName objectName, Object managedResource) throws MalformedObjectNameException {
        Hashtable<String, String> keyProperties = objectName.getKeyPropertyList();
        keyProperties.put("identity", Integer.toHexString(System.identityHashCode(managedResource)));
        return ObjectName.getInstance(objectName.getDomain(), keyProperties);
    }

    public static boolean isMBean(Class beanClass) {
        return beanClass != null && (DynamicMBean.class.isAssignableFrom(beanClass) || JmxUtils.getMBeanInterface(beanClass) != null || JmxUtils.getMXBeanInterface(beanClass) != null);
    }

    public static Class getMBeanInterface(Class clazz) {
        Class<?>[] implementedInterfaces;
        if (clazz.getSuperclass() == null) {
            return null;
        }
        String mbeanInterfaceName = String.valueOf(clazz.getName()) + MBEAN_SUFFIX;
        Class<?>[] classArray = implementedInterfaces = clazz.getInterfaces();
        int n = implementedInterfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> iface = classArray[n2];
            if (iface.getName().equals(mbeanInterfaceName)) {
                return iface;
            }
            ++n2;
        }
        return JmxUtils.getMBeanInterface(clazz.getSuperclass());
    }

    public static Class getMXBeanInterface(Class clazz) {
        Class<?>[] implementedInterfaces;
        if (clazz.getSuperclass() == null) {
            return null;
        }
        Class<?>[] classArray = implementedInterfaces = clazz.getInterfaces();
        int n = implementedInterfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Boolean checkResult;
            Class<?> iface = classArray[n2];
            boolean isMxBean = iface.getName().endsWith(MXBEAN_SUFFIX);
            if (mxBeanAnnotationAvailable && (checkResult = MXBeanChecker.evaluateMXBeanAnnotation(iface)) != null) {
                isMxBean = checkResult;
            }
            if (isMxBean) {
                return iface;
            }
            ++n2;
        }
        return JmxUtils.getMXBeanInterface(clazz.getSuperclass());
    }

    public static void populateDeprecation(Descriptor desc, AccessibleObject object) {
        if (object != null && object.isAnnotationPresent(Deprecated.class)) {
            desc.setField("deprecated", "");
        }
    }

    public static void populateDisplayName(Descriptor desc, String name) {
        desc.setField("displayName", name);
    }

    public static void populateEnable(Descriptor desc, boolean enabled) {
        desc.setField("enabled", "" + enabled);
    }

    public static void populateRole(Descriptor desc, Role role) {
        desc.setField("role", role.toString());
    }

    public static void populateVisibility(Descriptor desc, int level) {
        desc.setField("visibility", level);
    }

    public static void populateAccessors(Descriptor desc, BeanProperty property) {
        if (property.isReadable()) {
            desc.setField("getMethod", property.getReadMethod().getName());
        }
        if (property.isWritable()) {
            desc.setField("setMethod", property.getWriteMethod().getName());
        }
    }

    private static class MXBeanChecker {
        private MXBeanChecker() {
        }

        public static Boolean evaluateMXBeanAnnotation(Class<?> iface) {
            MXBean mxBean = iface.getAnnotation(MXBean.class);
            return mxBean != null ? Boolean.valueOf(mxBean.value()) : null;
        }
    }
}

