/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.i18n;

import com.ovea.tajin.framework.i18n.I18NBundle;
import com.ovea.tajin.framework.i18n.I18NService;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class I18NServiceSkeleton
implements I18NService {
    private final ConcurrentMap<Locale, I18NBundle> cache = new ConcurrentHashMap<Locale, I18NBundle>();
    private final String bundleName;
    private boolean debug;
    private I18NService.MissingKeyBehaviour missingKeyBehaviour = I18NService.MissingKeyBehaviour.THROW_EXCEPTION;

    protected I18NServiceSkeleton(String bundleName) {
        this.bundleName = bundleName.startsWith("/") ? bundleName.substring(1) : bundleName;
    }

    public I18NService.MissingKeyBehaviour getMissingKeyBehaviour() {
        return this.missingKeyBehaviour;
    }

    public void setMissingKeyBehaviour(I18NService.MissingKeyBehaviour missingKeyBehaviour) {
        this.missingKeyBehaviour = missingKeyBehaviour;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public final I18NBundle getBundle(Locale locale) {
        I18NBundle bundle = (I18NBundle)this.cache.get(locale);
        if (bundle == null) {
            this.cache.putIfAbsent(locale, this.newBundle(this.bundleName, locale));
            bundle = (I18NBundle)this.cache.get(locale);
        }
        return bundle;
    }

    public final String toString() {
        return this.bundleName;
    }

    abstract I18NBundle newBundle(String var1, Locale var2);
}

