/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.jmx;

import com.mycila.jmx.BeanProperty;
import com.mycila.jmx.BeanUtils;
import com.mycila.jmx.MetadataAssemblerSkeleton;
import com.mycila.jmx.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;

public abstract class ReflectionMetadataAssemblerSkeleton
extends MetadataAssemblerSkeleton {
    @Override
    protected Collection<Field> getAttributes(Class<?> managedClass) {
        LinkedList<Field> fields = new LinkedList<Field>();
        while (managedClass != null && !managedClass.equals(Object.class)) {
            Field[] fieldArray = managedClass.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (!field.isSynthetic() && this.canInclude(managedClass, field)) {
                    fields.add(field);
                }
                ++n2;
            }
            managedClass = managedClass.getSuperclass();
        }
        return fields;
    }

    protected abstract boolean canInclude(Class<?> var1, Field var2);

    @Override
    protected Collection<BeanProperty> getProperties(Class<?> managedClass) {
        HashMap<String, BeanProperty> properties = new HashMap<String, BeanProperty>();
        for (BeanProperty prop : BeanUtils.getProperties(managedClass)) {
            if (properties.containsKey(prop.getName()) || !this.canInclude(managedClass, prop)) continue;
            properties.put(prop.getName(), prop);
        }
        return properties.values();
    }

    protected abstract boolean canInclude(Class<?> var1, BeanProperty var2);

    @Override
    protected Collection<Method> getMethodOperations(Class<?> managedClass) {
        LinkedList<Method> methods = new LinkedList<Method>();
        for (Method method : ReflectionUtils.getDeclaredMethods(managedClass)) {
            if (!this.canInclude(managedClass, method)) continue;
            methods.add(method);
        }
        return methods;
    }

    protected abstract boolean canInclude(Class<?> var1, Method var2);
}

