/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.servlet.ContinuingHttpServletRequest;
import com.google.inject.servlet.GuiceFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ServletScopes {
    public static final Scope REQUEST = new Scope(){

        @Override
        public <T> Provider<T> scope(Key<T> key, final Provider<T> creator) {
            final String name = key.toString();
            return new Provider<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public T get() {
                    HttpServletRequest request;
                    Map scopeMap;
                    if (GuiceFilter.localContext.get() == null && (scopeMap = (Map)requestScopeContext.get()) != null) {
                        Object t = scopeMap.get(name);
                        if (NullObject.INSTANCE == t) {
                            return null;
                        }
                        if (t == null) {
                            t = creator.get();
                            scopeMap.put(name, t != null ? t : NullObject.INSTANCE);
                        }
                        return t;
                    }
                    HttpServletRequest httpServletRequest = request = GuiceFilter.getRequest();
                    synchronized (httpServletRequest) {
                        Object obj;
                        block8: {
                            obj = request.getAttribute(name);
                            if (NullObject.INSTANCE != obj) break block8;
                            return null;
                        }
                        Object t = obj;
                        if (t == null) {
                            t = creator.get();
                            request.setAttribute(name, t != null ? t : NullObject.INSTANCE);
                        }
                        return t;
                    }
                }

                public String toString() {
                    return String.format("%s[%s]", creator, REQUEST);
                }
            };
        }

        @Override
        public String toString() {
            return "ServletScopes.REQUEST";
        }
    };
    public static final Scope SESSION = new Scope(){

        @Override
        public <T> Provider<T> scope(Key<T> key, final Provider<T> creator) {
            final String name = key.toString();
            return new Provider<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public T get() {
                    HttpSession session;
                    HttpSession httpSession = session = GuiceFilter.getRequest().getSession();
                    synchronized (httpSession) {
                        Object obj;
                        block5: {
                            obj = session.getAttribute(name);
                            if (NullObject.INSTANCE != obj) break block5;
                            return null;
                        }
                        Object t = obj;
                        if (t == null) {
                            t = creator.get();
                            session.setAttribute(name, t != null ? t : NullObject.INSTANCE);
                        }
                        return t;
                    }
                }

                public String toString() {
                    return String.format("%s[%s]", creator, SESSION);
                }
            };
        }

        @Override
        public String toString() {
            return "ServletScopes.SESSION";
        }
    };
    private static final ThreadLocal<Map<String, Object>> requestScopeContext = new ThreadLocal();

    private ServletScopes() {
    }

    public static <T> Callable<T> continueRequest(final Callable<T> callable, Map<Key<?>, Object> seedMap) {
        Preconditions.checkArgument(seedMap != null, "Seed map cannot be null, try passing in Collections.emptyMap() instead.");
        ContinuingHttpServletRequest continuingRequest = new ContinuingHttpServletRequest(GuiceFilter.getRequest());
        for (Map.Entry<Key<?>, Object> entry : seedMap.entrySet()) {
            Object value = ServletScopes.validateAndCanonicalizeValue(entry.getKey(), entry.getValue());
            continuingRequest.setAttribute(entry.getKey().toString(), value);
        }
        return new Callable<T>(continuingRequest){
            private HttpServletRequest request;
            {
                this.request = continuingHttpServletRequest;
            }

            @Override
            public T call() throws Exception {
                GuiceFilter.Context context = GuiceFilter.localContext.get();
                Preconditions.checkState(context == null, "Cannot continue request in the same thread as a HTTP request!");
                GuiceFilter.localContext.set(new GuiceFilter.Context(this.request, null));
                try {
                    Object v = callable.call();
                    return v;
                }
                finally {
                    if (context == null) {
                        GuiceFilter.localContext.remove();
                    }
                }
            }
        };
    }

    public static <T> Callable<T> scopeRequest(final Callable<T> callable, Map<Key<?>, Object> seedMap) {
        Preconditions.checkArgument(seedMap != null, "Seed map cannot be null, try passing in Collections.emptyMap() instead.");
        final HashMap<String, Object> scopeMap = Maps.newHashMap();
        for (Map.Entry<Key<?>, Object> entry : seedMap.entrySet()) {
            Object value = ServletScopes.validateAndCanonicalizeValue(entry.getKey(), entry.getValue());
            scopeMap.put(entry.getKey().toString(), value);
        }
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                Preconditions.checkState(GuiceFilter.localContext.get() == null, "An HTTP request is already in progress, cannot scope a new request in this thread.");
                Preconditions.checkState(requestScopeContext.get() == null, "A request scope is already in progress, cannot scope a new request in this thread.");
                requestScopeContext.set(scopeMap);
                try {
                    Object v = callable.call();
                    return v;
                }
                finally {
                    requestScopeContext.remove();
                }
            }
        };
    }

    private static Object validateAndCanonicalizeValue(Key<?> key, Object object) {
        if (object == null || object == NullObject.INSTANCE) {
            return NullObject.INSTANCE;
        }
        if (!key.getTypeLiteral().getRawType().isInstance(object)) {
            throw new IllegalArgumentException("Value[" + object + "] of type[" + object.getClass().getName() + "] is not compatible with key[" + key + "]");
        }
        return object;
    }

    static enum NullObject {
        INSTANCE;

    }
}

