/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.template;

import com.ovea.tajin.framework.io.Resource;
import com.ovea.tajin.framework.template.ResolvedTemplate;
import com.ovea.tajin.framework.template.TemplateCompiler;
import com.ovea.tajin.framework.template.TemplateResolver;
import com.ovea.tajin.framework.template.TemplateResolverException;
import java.util.Locale;

abstract class TemplateResolverSkeleton
implements TemplateResolver {
    protected final TemplateCompiler compiler;

    protected TemplateResolverSkeleton(TemplateCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public final ResolvedTemplate resolve(String path, Locale locale) throws TemplateResolverException {
        int pos;
        if (path == null) {
            throw new TemplateResolverException("Empty path");
        }
        StringBuilder templateName = new StringBuilder(path);
        if (templateName.charAt(0) == '/') {
            templateName.deleteCharAt(0);
        }
        if ((pos = templateName.lastIndexOf(".")) == -1) {
            throw new TemplateResolverException("Illegal path: extension needed");
        }
        String[] locales = new String[]{"_" + locale, "_" + locale.getLanguage(), ""};
        int i = 0;
        int prev = 2;
        while (i < locales.length) {
            templateName.replace(pos, pos + locales[prev].length(), locales[i]);
            Resource tmpl = this.tryPath(templateName.toString());
            if (tmpl != null) {
                return this.compiler.compile(tmpl);
            }
            prev = (2 + ++i) % 3;
        }
        throw new TemplateResolverException("Cannot resolve template for path " + path);
    }

    protected abstract Resource tryPath(String var1);
}

