/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.i18n;

import com.ovea.tajin.framework.i18n.I18NBundle;
import com.ovea.tajin.framework.i18n.I18NService;
import com.ovea.tajin.framework.i18n.MissingMessageException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Locale;

public abstract class I18NBundleSkeleton
implements I18NBundle {
    protected final ClassLoader loader;
    private final String bundleName;
    private final Locale locale;
    private final I18NService.MissingKeyBehaviour missingKeyBehaviour;

    protected I18NBundleSkeleton(String bundleName, Locale locale, I18NService.MissingKeyBehaviour missingKeyBehaviour) {
        this.bundleName = bundleName;
        this.locale = locale;
        this.loader = new URLClassLoader(new URL[0], Thread.currentThread().getContextClassLoader());
        this.missingKeyBehaviour = missingKeyBehaviour;
    }

    @Override
    public final String message(String key) throws MissingMessageException {
        return this.message(key, new Object[0]);
    }

    @Override
    public final String message(String key, Object ... params) throws MissingMessageException {
        if (key == null) {
            throw new IllegalArgumentException("Missing key !");
        }
        String str = this.getValue(key);
        if (str == null || str.length() == 0) {
            switch (this.missingKeyBehaviour) {
                case RETURN_KEY: {
                    str = "[" + key + "]";
                    break;
                }
                case RETURN_NULL: {
                    return null;
                }
                case THROW_EXCEPTION: {
                    throw new MissingMessageException(this.bundleName(), this.locale(), key);
                }
            }
        }
        return params == null || params.length == 0 ? str : MessageFormat.format(str, params);
    }

    public final String toString() {
        return String.valueOf(this.bundleName) + " (" + this.locale + ")";
    }

    abstract String getValue(String var1);

    final String bundleName() {
        return this.bundleName;
    }

    final Locale locale() {
        return this.locale;
    }
}

