/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.template.web;

import com.ovea.tajin.framework.template.CachingTemplateCompiler;
import com.ovea.tajin.framework.template.CachingTemplateResolver;
import com.ovea.tajin.framework.template.FileSystemTemplateResolver;
import com.ovea.tajin.framework.template.GroovyTemplateCompiler;
import com.ovea.tajin.framework.template.TemplateCompiler;
import com.ovea.tajin.framework.template.TemplateResolver;
import com.ovea.tajin.framework.template.TemplateResolverException;
import com.ovea.tajin.framework.template.web.CachingFixture;
import com.ovea.tajin.framework.template.web.ContextProvider;
import com.ovea.tajin.framework.template.web.DynamicMarkupDataBuilder;
import com.ovea.tajin.framework.template.web.LocaleProvider;
import com.ovea.tajin.framework.template.web.MarkupData;
import com.ovea.tajin.framework.template.web.MarkupDataBuilder;
import com.ovea.tajin.framework.template.web.MarkupOptions;
import com.ovea.tajin.framework.template.web.StaticMarkupDataBuilder;
import com.ovea.tajin.framework.util.MimeTypes;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public final class MarkupServlet
extends HttpServlet {
    private static Logger LOGGER = Logger.getLogger(MarkupServlet.class.getName());
    private static final long serialVersionUID = -9052484265570140129L;
    private MarkupOptions markupOptions;
    private LocaleProvider localeProvider;
    private ContextProvider contextProvider;
    private MarkupDataBuilder markupDataBuilder;
    private CachingFixture cachingFixture;

    public void setLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
    }

    public void setContextProvider(ContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.markupOptions = MarkupOptions.from(config);
        TemplateCompiler compiler = !this.markupOptions.debug && this.markupOptions.compilerCache ? new CachingTemplateCompiler(this.newCompiler(this.markupOptions)) : this.newCompiler(this.markupOptions);
        TemplateResolver resolver = !this.markupOptions.debug && this.markupOptions.resolverCache ? new CachingTemplateResolver(new FileSystemTemplateResolver(compiler, this.markupOptions.webappDir)) : new FileSystemTemplateResolver(compiler, this.markupOptions.webappDir);
        this.localeProvider = MarkupServlet.nullSafe(this.localeProvider != null ? this.localeProvider : new LocaleProvider(){

            @Override
            public Locale get(HttpServletRequest request) {
                return null;
            }
        });
        this.contextProvider = MarkupServlet.nullSafe(this.contextProvider != null ? this.contextProvider : new ContextProvider(){

            @Override
            public Map<String, Object> build(HttpServletRequest request, HttpServletResponse response) {
                return null;
            }
        });
        this.cachingFixture = new CachingFixture(this.markupOptions);
        this.markupDataBuilder = new DynamicMarkupDataBuilder(this.contextProvider, this.localeProvider, this.markupOptions, resolver);
        if (!this.markupOptions.debug && !this.markupOptions.dynamic) {
            this.markupDataBuilder = new StaticMarkupDataBuilder(this.markupDataBuilder, this.localeProvider);
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int pos;
        String path = request.getRequestURI();
        if (path.startsWith(request.getContextPath())) {
            path = path.substring(request.getContextPath().length());
        }
        if (path != null && (pos = path.lastIndexOf(46)) != -1) {
            String extension;
            int end = (path = path.toLowerCase()).indexOf(";", pos);
            if (end != -1) {
                path = path.substring(0, end);
            }
            if (this.markupOptions.markups.contains(extension = path.substring(pos + 1))) {
                MarkupData markupData = this.markupDataBuilder.build(request, response, path);
                if (markupData.hasError()) {
                    RuntimeException e = markupData.error;
                    int status = e instanceof TemplateResolverException ? 404 : 500;
                    response.sendError(status);
                    if (status == 404) {
                        LOGGER.log(Level.WARNING, "Error serving markup " + path + " : " + e.getMessage(), e);
                    } else {
                        LOGGER.log(Level.SEVERE, "Error serving markup " + path + " : " + e.getMessage(), e);
                    }
                    return;
                }
                if (this.cachingFixture.isModified(request, response, markupData)) {
                    response.setContentType(MimeTypes.getContentTypeForExtension(extension));
                    response.setCharacterEncoding(this.markupOptions.defaultCharset);
                    if (this.markupOptions.gzip && MarkupServlet.acceptsGZipEncoding(request)) {
                        response.setHeader("Content-Encoding", "gzip");
                        response.setContentLength(markupData.gzip.length);
                        response.getOutputStream().write(markupData.gzip);
                    } else {
                        response.setContentLength(markupData.data.length);
                        response.getOutputStream().write(markupData.data);
                    }
                    response.setStatus(200);
                }
                return;
            }
        }
        response.sendError(404);
    }

    protected TemplateCompiler newCompiler(MarkupOptions markupOptions) {
        return new GroovyTemplateCompiler(markupOptions.defaultCharset);
    }

    private static LocaleProvider nullSafe(final LocaleProvider localeProvider) {
        return new LocaleProvider(){

            @Override
            public Locale get(HttpServletRequest request) {
                Locale locale = localeProvider.get(request);
                if (locale == null) {
                    locale = request.getLocale();
                }
                return locale != null ? locale : Locale.US;
            }
        };
    }

    private static ContextProvider nullSafe(final ContextProvider contextProvider) {
        return new ContextProvider(){

            @Override
            public Map<String, Object> build(HttpServletRequest request, HttpServletResponse response) {
                String key;
                Enumeration<String> e;
                LinkedHashMap<String, Object> attributes;
                Map<String, Object> ctx = contextProvider.build(request, response);
                ctx = ctx == null ? new HashMap<String, Object>() : new HashMap<String, Object>(ctx);
                if (!ctx.containsKey("req")) {
                    ctx.put("req", request);
                }
                if (!ctx.containsKey("res")) {
                    ctx.put("res", response);
                }
                if (!ctx.containsKey("sess")) {
                    attributes = new LinkedHashMap<String, Object>();
                    HttpSession session = request.getSession(false);
                    if (session != null) {
                        Enumeration<String> e2 = session.getAttributeNames();
                        while (e2.hasMoreElements()) {
                            String key2 = e2.nextElement();
                            attributes.put(key2, session.getAttribute(key2));
                        }
                    }
                    ctx.put("sess", attributes);
                }
                if (!ctx.containsKey("attr")) {
                    attributes = new LinkedHashMap();
                    e = request.getAttributeNames();
                    while (e.hasMoreElements()) {
                        key = e.nextElement();
                        attributes.put(key, request.getAttribute(key));
                    }
                    ctx.put("attr", attributes);
                }
                if (!ctx.containsKey("param")) {
                    attributes = new LinkedHashMap();
                    e = request.getParameterNames();
                    while (e.hasMoreElements()) {
                        key = e.nextElement();
                        attributes.put(key, request.getParameter(key));
                    }
                    ctx.put("param", attributes);
                }
                return ctx;
            }
        };
    }

    private static boolean acceptsGZipEncoding(HttpServletRequest request) {
        String acceptEncoding = request.getHeader("Accept-Encoding");
        return acceptEncoding != null && acceptEncoding.contains("gzip");
    }
}

