/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.guice.ext.service;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;

public class SingleServiceProvider<T>
implements Provider<T> {
    @Inject
    private Injector injector;
    private final Class<T> type;
    private final ClassLoader classLoader;
    private boolean failIfNotFound = true;

    public SingleServiceProvider(Class<T> type) {
        this(type, type.getClassLoader());
    }

    public SingleServiceProvider(Class<T> type, ClassLoader classLoader) {
        this.type = type;
        this.classLoader = classLoader;
    }

    public SingleServiceProvider<T> allowMissingImplementation() {
        this.failIfNotFound = false;
        return this;
    }

    @Override
    public T get() {
        try {
            T instance = ServiceLoader.load(this.type, this.classLoader).iterator().next();
            this.injector.injectMembers(instance);
            return instance;
        }
        catch (NoSuchElementException noSuchElementException) {
            if (this.failIfNotFound) {
                throw new ProvisionException("No implementation found in classpath for interface: " + this.type.getName());
            }
            return null;
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.type.getName() + "]";
    }
}

