/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.guice.ext.jsr250;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.mycila.guice.ext.injection.MethodHandler;
import com.mycila.guice.ext.injection.MethodInvoker;
import com.mycila.guice.ext.injection.Reflect;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Provider;

class Jsr250PostConstructHandler
implements MethodHandler<PostConstruct> {
    @Inject
    Provider<Injector> injector;

    Jsr250PostConstructHandler() {
    }

    @Override
    public void handle(TypeLiteral<?> type, Object instance, Method method, PostConstruct annotation) {
        if (!Modifier.isStatic(method.getModifiers())) {
            List<Key<?>> parameterKeys = Reflect.getParameterKeys(type, method);
            Object[] parameters = new Object[parameterKeys.size()];
            int i = 0;
            while (i < parameters.length) {
                parameters[i] = this.injector.get().getProvider(parameterKeys.get(i)).get();
                ++i;
            }
            MethodInvoker.on(method).invoke(instance, parameters);
        }
    }
}

